#ifndef __SELECTTABLE__
#define __SELECTTABLE__

#include <qtablevw.h>
#include <qpixmap.h>
#include <qlist.h>

class SelectTable;

class SelectTableItem
{
protected:

	QPixmap		pmap;
	const char	*txt;
	int		nid;

public:

	SelectTableItem(SelectTable *parent,int id=-1,const char *title=0,QPixmap &p=0);
	~SelectTableItem();

	void		setText(const char *t);
	const char	*text() const;
	void		setPixmap(const QPixmap &p);
	const QPixmap	*pixmap() const;
	const QPixmap	&getPixmap() const;

	int		id();
};

class SelectTable : public QTableView
{
	Q_OBJECT
protected:

	QList<SelectTableItem>	itemlist;
	int			highlight_id;
	int			select_id;

public:

	SelectTable(QWidget *parent = 0,const char *name = 0,WFlags f=0);
	~SelectTable();

	bool		insertItem(SelectTableItem *);
	SelectTableItem	*item(int id);

	int		maxID();

signals:

	void		selected(int id);
	void		highlighted(int id);

protected:

	virtual void	paintCell(QPainter *p,int row,int col);

	virtual void	mouseDoubleClickEvent(QMouseEvent*);
	virtual void	mouseReleaseEvent(QMouseEvent*);
};

#endif


