#include "selecttable.h"
#include "selecttable.moc"

#include <qpainter.h>

#include <stdio.h>

SelectTable::SelectTable(QWidget *parent = 0,const char *name = 0,WFlags f=0) :
	QTableView(parent,name,f)
{
	initMetaObject();

	setTableFlags(Tbl_autoVScrollBar|Tbl_autoHScrollBar|Tbl_smoothVScrolling|
		Tbl_clipCellPainting);

	setNumRows(1);
	setNumCols(0);
	setAutoUpdate(TRUE);

	setCellWidth(110);
	setCellHeight(130);

	highlight_id = -1;
	select_id = -1;
}

SelectTable::~SelectTable()
{
}

bool		SelectTable::insertItem(SelectTableItem *i)
{
	bool	ok;

	ok = itemlist.insert(i->id(),i);

	if(ok)
	{
		if((unsigned)(numRows() * numCols()) < itemlist.count())
		{
			if(numCols() * cellWidth() < width())
			{
				setNumCols(numCols() + 1);
				return ok;
			}
			if(numRows() * cellHeight() < height())
			{
				setNumRows(numRows() + 1);
				return ok;
			}
			if(numRows() < numCols())
			{
				setNumRows(numRows() + 1);
			}
			else
			{
				setNumCols(numCols() + 1);
			}
		}
	}

	return ok;
}

SelectTableItem		*SelectTable::item(int i)
{
	SelectTableItem	*sti;

	sti = itemlist.getFirst();
	while(sti)
	{
		if(sti->id() == i) return sti;
		sti = itemlist.next();
	}

	return NULL;
}

int		SelectTable::maxID()
{
	SelectTableItem	*sti;

	sti = itemlist.getLast();
	if(!sti) return -1;

	return sti->id();
}

void		SelectTable::paintCell(QPainter *p,int row,int col)
{
	const char	*text;
	int		id;
	SelectTableItem	*sti;

	if((unsigned)(id = row * numCols() + col) >= itemlist.count()) return;

	sti = itemlist.at(id);

	const QPixmap	&pmap = sti->getPixmap();
	text = sti->text();

	p->drawPixmap(5,5,pmap);

	if(id == highlight_id)
		p->setPen(QColor(255,255,255));
	else
		p->setPen(QColor(0,0,0));

	p->drawRect(4,4,102,102);
	p->drawText(1,pmap.height() + 7,108,128 - 7 - pmap.height(),
		AlignCenter | WordBreak,text);
}

void		SelectTable::mouseDoubleClickEvent(QMouseEvent *me)
{
	int		row,col,id;

	row = findRow(me->y());
	col = findCol(me->x());

	if(row < 0 || col < 0) return;
	if((unsigned)(id = row * numCols() + col) >= itemlist.count()) return;

	select_id = id;

	emit selected(id);
}

void		SelectTable::mouseReleaseEvent(QMouseEvent *me)
{
	int		row,col,id;

	highlight_id = -1;

	repaint(FALSE);

	row = findRow(me->y());
	col = findCol(me->x());

	if(row < 0 || col < 0) return;
	if((unsigned)(id = row * numCols() + col) >= itemlist.count()) return;

	highlight_id = id;

	emit highlighted(id);

	repaint(FALSE);
}



#ifdef TEST_SELECTTABLE

#include <kapp.h>

KApplication	*mykapp;


void	main(int argc,char **argv)
{
	SelectTable	*win;
	SelectTableItem	*sti[2];
	QPixmap		*pm[2];

	mykapp = new KApplication(argc,argv,"k3de");
	win = new SelectTable();

	pm[0] = new QPixmap("crackle.ppm");
	pm[1] = new QPixmap("marble.ppm");

	sti[0] = new SelectTableItem(win,-1,"Crackle",*(pm[0]));
	sti[1] = new SelectTableItem(win,-1,"Marble",*(pm[1]));

	mykapp->setMainWidget(win);

	win->resize(500,345);
	win->setMaximumSize(1000,700);
	win->setMinimumSize(500,200);

	win->show();

	win->repaint();

	return mykapp->exec();
}


#endif


