#ifndef __MAINWIN__
#define __MAINWIN__

#include "worldtree.h"
#include "viewwidget.h"
#include "texturetable.h"
#include "version.h"

#include <ktopwidget.h>
#include <knewpanner.h>
#include <ktoolbar.h>

#define MPopupMenu	QPopupMenu

class MainWin : public KTopLevelWidget
{
	Q_OBJECT
protected:
	WorldTree	*worldtree;
	ViewWidget	*viewwidget;
	TextureTable	*textable;
	KNewPanner	*hpanner,*vpanner;

	MPopupMenu	*Mfile,*Medit,*Mobjects,*Mpov,*Mtexture,*Moptions,*Mhelp,*Mopenrecent;
	KMenuBar	*mainmenu;
	KToolBar	*tbview;

	int		mid[60];
	int		changed;
	char		*projectname;

public:
	MainWin(char *name = 0L);
	~MainWin();

	void	paintEvent(QPaintEvent*);
	void	show();

private:
	void	createMenu();
	void	createWidgets();

public slots:
	// Menu File
	void	newClicked();
	void	openClicked();
	//void	openRecentClicked(int);
	void	saveClicked();
	void	saveAsClicked();
	void	dumpClicked();
	void	quitClicked();

	// Menu Objects
	void	addObjectClicked();
	void	addCSGClicked();
	void	addBlobClicked();
	void	addRefClicked();
	void	addSphereClicked();
	void	addCylinderClicked();
	void	addBoxClicked();
	void	addMeshClicked();
	void	addRefPtrClicked();
	void	addConeClicked();
	void	addPlaneClicked();
	void	addTorusClicked();
	void	addTriangleClicked();
	void	addHeightfieldClicked();

	void	addLightPointClicked();
	void	addSpotLightClicked();
	void	addAreaLightClicked();
//	void	addLightPointClicked();

	// Menu POV
	void	exportPOVClicked();

	// Menu Texture
	void	newTextureClicked();

	// Toolbar
	void	setViewMode(int);

signals:
	void	viewMode(int);
	void	projectionMode(int);

};

#endif

