#include <kapp.h>
#include <klocale.h>
#include <kmsgbox.h>

#include <qkeycode.h>

#include <misc.h>

#include "KFileDialog.h"
#include "dialogs.h"

#define stloc(a)	((char*)klocale->translate((a)))

#include "mainwin.h"
#include "mainwin.moc"

#include "icons/fov.xpm"
#include "icons/moveview.xpm"
#include "icons/rotateview.xpm"

#include "icons/scale.xpm"
#include "icons/translate.xpm"
#include "icons/rotate.xpm"

#include "icons/3dview.xpm"
#include "icons/xyview.xpm"
#include "icons/xzview.xpm"
#include "icons/zyview.xpm"

MainWin::MainWin(char *name) :
	KTopLevelWidget(name)
{
	createWidgets();
	createMenu();
	changed = 0;
	projectname = NULL;
}

MainWin::~MainWin()
{
	if(projectname) free(projectname);
}

void	MainWin::createWidgets()
{
	vpanner = new KNewPanner(this,0,KNewPanner::Horizontal,KNewPanner::Percent,80);
	hpanner = new KNewPanner(vpanner,0,KNewPanner::Vertical,KNewPanner::Percent,30);

	worldtree = new WorldTree(hpanner);
	viewwidget = new ViewWidget(hpanner);
	textable = new TextureTable(vpanner);

	hpanner->activate(worldtree,viewwidget);
	vpanner->activate(hpanner,textable);

	setView(vpanner);

	connect(worldtree,SIGNAL(setWorld(world*)),viewwidget,SLOT(setWorld(world*)));
	connect(worldtree,SIGNAL(redraw()),viewwidget,SLOT(draw()));
	connect(textable,SIGNAL(setTexture(texture*)),worldtree,SLOT(setTexture(texture*)));



	tbview = new KToolBar(this);
	tbview->insertButton(QPixmap(fov_xpm),1,true,"Change camera focus");
	tbview->insertButton(QPixmap(moveview_xpm),2,true,"Change camera position");
	tbview->insertButton(QPixmap(rotateview_xpm),3,true,"Change camera angle");
	tbview->setToggle(1);
	tbview->setToggle(2);
	tbview->setToggle(3);
	tbview->insertButton(QPixmap(scale_xpm),4,true,"Change object size");
	tbview->insertButton(QPixmap(translate_xpm),5,true,"Change object position");
	tbview->insertButton(QPixmap(rotate_xpm),6,true,"Change object angle");
	tbview->setToggle(4);
	tbview->setToggle(5);
	tbview->setToggle(6);
	tbview->insertSeparator();
	tbview->insertButton(QPixmap(_3dview_xpm),7,true,"Change camera to 3d-projection");
	tbview->insertButton(QPixmap(xyview_xpm),8,true,"Change camera to xy-projection");
	tbview->insertButton(QPixmap(xzview_xpm),9,true,"Change camera to xz-projection");
	tbview->insertButton(QPixmap(zyview_xpm),10,true,"Change camera to zy-projection");
	tbview->setToggle(7);
	tbview->setToggle(8);
	tbview->setToggle(9);
	tbview->setToggle(10);
	tbview->setButton(1,true);
	tbview->setButton(7,true);

	addToolBar(tbview);

	connect(tbview,SIGNAL(toggled(int)),this,SLOT(setViewMode(int)));
	connect(tbview,SIGNAL(clicked(int)),this,SLOT(setViewMode(int)));
	connect(this,SIGNAL(viewMode(int)),viewwidget,SLOT(setViewMode(int)));
	connect(this,SIGNAL(projectionMode(int)),viewwidget,SLOT(setProjectionMode(int)));

	connect(worldtree,SIGNAL(setSelected(base*)),viewwidget,SLOT(setSelected(base*)));
}

void	MainWin::createMenu()
{
	Mfile = new MPopupMenu;
	CHECK_PTR(Mfile);

	mid[0] = Mfile->insertItem(klocale->translate("New"),this,SLOT(newClicked()),CTRL+Key_N);
	Mfile->insertSeparator();
	mid[1] = Mfile->insertItem(klocale->translate("Open"),this,SLOT(openClicked()),CTRL+Key_O);
/*
	mid[2] = Mfile->insertItem(klocale->translate("Open Recent"),Mopenrecent);
*/
	Mfile->insertSeparator();
	mid[3] = Mfile->insertItem(klocale->translate("Save"),this,SLOT(saveClicked()),CTRL+Key_S);
	mid[4] = Mfile->insertItem(klocale->translate("Save As"),this,SLOT(saveAsClicked()),0);
	Mfile->insertSeparator();
	mid[5] = Mfile->insertItem(klocale->translate("Dump"),this,SLOT(dumpClicked()),0);
	Mfile->insertSeparator();
	mid[6] = Mfile->insertItem(klocale->translate("Exit"),this,SLOT(quitClicked()),CTRL+Key_Q);


	Mobjects = new MPopupMenu;
	CHECK_PTR(Mobjects);

	mid[10] = Mobjects->insertItem(klocale->translate("Add Object"),this,SLOT(addObjectClicked()),0);
	mid[11] = Mobjects->insertItem(klocale->translate("Add CSG"),this,SLOT(addCSGClicked()),0);
	mid[12] = Mobjects->insertItem(klocale->translate("Add Blob"),this,SLOT(addBlobClicked()),0);
	Mobjects->insertSeparator();
	mid[13] = Mobjects->insertItem(klocale->translate("Add RefrenceObject"),this,SLOT(addRefClicked()),0);
	Mobjects->insertSeparator();
	mid[14] = Mobjects->insertItem(klocale->translate("Add Sphere"),this,SLOT(addSphereClicked()),0);
	mid[15] = Mobjects->insertItem(klocale->translate("Add Cylinder"),this,SLOT(addCylinderClicked()),0);
	Mobjects->insertSeparator();
	mid[16] = Mobjects->insertItem(klocale->translate("Add Box"),this,SLOT(addBoxClicked()),0);
	mid[17] = Mobjects->insertItem(klocale->translate("Add Cone"),this,SLOT(addConeClicked()),0);
	mid[18] = Mobjects->insertItem(klocale->translate("Add Torus"),this,SLOT(addTorusClicked()),0);
	mid[22] = Mobjects->insertItem(klocale->translate("Add Heightfield"),this,SLOT(addHeightfieldClicked()),0);
	mid[21] = Mobjects->insertItem(klocale->translate("Add Plane"),this,SLOT(addPlaneClicked()),0);
	Mobjects->insertSeparator();
	mid[19] = Mobjects->insertItem(klocale->translate("Add Mesh"),this,SLOT(addMeshClicked()),0);
	mid[23] = Mobjects->insertItem(klocale->translate("Add Triangle"),this,SLOT(addTriangleClicked()),0);
	Mobjects->insertSeparator();
	mid[20] = Mobjects->insertItem(klocale->translate("Add Reference"),this,SLOT(addRefPtrClicked()),0);
	Mobjects->insertSeparator();
	mid[24] = Mobjects->insertItem(klocale->translate("Add Spotlight"),this,SLOT(addSpotLightClicked()),0);
	mid[25] = Mobjects->insertItem(klocale->translate("Add Arealight"),this,SLOT(addAreaLightClicked()),0);
	mid[26] = Mobjects->insertItem(klocale->translate("Add Lightpoint"),this,SLOT(addLightPointClicked()),0);

	Mtexture = new MPopupMenu;
	CHECK_PTR(Mtexture);

	mid[40] = Mtexture->insertItem(klocale->translate("new"),this,SLOT(newTextureClicked()),0);

	Mpov = new MPopupMenu;
	CHECK_PTR(Mpov);

	mid[30] = Mpov->insertItem(klocale->translate("export"),this,SLOT(exportPOVClicked()),0);

	Mhelp = new MPopupMenu;
	CHECK_PTR(Mhelp);

	extern KApplication	*mykapp;

	QString str = "K3DE V" VERSION " (c) 1998, 1999 Markus Weber, Tobias Wollgam \n\n";
/*
	str += klocale->translate("Soundfile editor for the");
	str += " KDE Desktop Environment\n\n";
	str += klocale->translate("Please report bugs to");
	str += ": wollgam@cww.de\n";
*/
	//KMsgBox	mb(0,stloc("About"),str,1,stloc("Quit"));
		       
	Mhelp = mykapp->getHelpMenu(true, str.data());

	mainmenu = new KMenuBar(this,"mainmenu");
	CHECK_PTR(mainmenu);
	mainmenu->insertItem(/*klocale->translate*/("&File"),Mfile);
//	mainmenu->insertItem(klocale->translate("&Edit"),Medit);
	mainmenu->insertItem(klocale->translate("&Objects"),Mobjects);
	mainmenu->insertItem(klocale->translate("&Texture"),Mtexture);
	mainmenu->insertItem(klocale->translate("&POV"),Mpov);
//	mainmenu->insertItem(klocale->translate("&Options"),Moptions);
	mainmenu->insertSeparator();
	mainmenu->insertItem(/*klocale->translate*/("&Help"),Mhelp);

	setMenu(mainmenu);
}

void	MainWin::newClicked()
{
	if(changed)
	{
		QString		str;
		int		result;

		str = "k3de V" VERSION " \n\n";
		str += /*klocale->translate*/("The data has changed and is currently not saved!");
		KMsgBox	mb;
		result = mb.yesNoCancel(0,/*stloc*/("New world?"),str,8,/*stloc*/("Abort"),stloc("Save now"),stloc("Load"));
		if(result == 1) return;
		if(result == 2) saveClicked();
	}
	worldtree->empty();
	changed = 0;
}

void	MainWin::quitClicked()
{
//	delete this;
	exit(0);
}

void	MainWin::openClicked()
{
	char		name[1024];
	KFileDialog	*fd;
	QString		qstr;

	if(changed)
	{
		QString		str;
		int		result;

		str = "k3de V" VERSION " \n\n";
		str += /*klocale->translate*/("The data has changed and is currently not saved!");
		KMsgBox	mb;
		result = mb.yesNoCancel(0,/*stloc*/("Load new soundfile?"),str,8,/*stloc*/("Abort"),stloc("Save now"),stloc("Load"));
		if(result == 1) return;
		if(result == 2) saveClicked();
	}

	fd = new KFileDialog();

	fd->exec();
	qstr = fd->getSelectedFile();
	strcpy(name,qstr.data());
	delete fd;

	if(worldtree->load(name) == 0)
		projectname = strdup(name);
//	worldtree->draw();
}

void	MainWin::saveClicked()
{
	if(worldtree->save(projectname) == 0)
		changed = 0;
}

void	MainWin::saveAsClicked()
{
	char		name[1024];
	KFileDialog	*fd;
	QString		qstr;

	fd = new KFileDialog();

	fd->exec();
	qstr = fd->getSelectedFile();
	strcpy(name,qstr.data());
	delete fd;

	if(worldtree->save(name) == 0)
	{
		projectname = strdup(name);
		changed = 0;
	}

//	worldtree->draw();
}

void	MainWin::dumpClicked()
{
	worldtree->dump();
}

void	MainWin::exportPOVClicked()
{
	char		name[1024];
	KFileDialog	*fd;
	QString		qstr;

	fd = new KFileDialog();

	fd->exec();
	qstr = fd->getSelectedFile();
	strcpy(name,qstr.data());
	delete fd;

	if(worldtree->exportPOV(name,viewwidget) == 0)
	{
	}
}

void	MainWin::newTextureClicked()
{
	char		tname[1024];
	char		fnppm[1024];
	char		com[2048];
	int		i;
	FILE		*fp;
	QPixmap		*pm;
	texture		*t = new texture("new texture",0.5,0.5,0.5);

	TextureDialog td(0,"Texture",t);

	td.show();

	if(td.result())
	{
		td.getTexture();

		sprintf(tname,"%s.tex",t->getName());
		sprintf(fnppm,"data/texture/%s.ppm",t->getName());

		for(i = 0;fnppm[i] != '\0';i++)
		{
			if(fnppm[i] == ' ') fnppm[i] = '_';
		}

		fp = fopen("data/texture/texture.pov","w");
		t->exportPOV(fp,0,4);
		fclose(fp);

		sprintf(com,"povray +Ldata/texture +FP +W100 +H100 +Itexturebody.pov +O%s",fnppm);

		system(com); sleep(4);

		pm = new QPixmap(fnppm);

		new TextureTableItem(textable,-1,t->getName(),*pm,t);
	}	
}

void	MainWin::addObjectClicked()
{
	worldtree->addObject();
}

void	MainWin::addCSGClicked()
{
	worldtree->addCSG();
}

void	MainWin::addBlobClicked()
{
	worldtree->addBlob();
}

void	MainWin::addRefClicked()
{
	worldtree->addRef();
}

void	MainWin::addSphereClicked()
{
	worldtree->addSphere();
}

void	MainWin::addCylinderClicked()
{
	worldtree->addCylinder();
}

void	MainWin::addBoxClicked()
{
	worldtree->addBox();
}

void	MainWin::addMeshClicked()
{
	worldtree->addMesh();
}

void	MainWin::addRefPtrClicked()
{
	worldtree->addRefPtr();
}

void	MainWin::addConeClicked()
{
	worldtree->addCone();
}

void	MainWin::addPlaneClicked()
{
	worldtree->addPlane();
}

void	MainWin::addTorusClicked()
{
	worldtree->addTorus();
}

void	MainWin::addTriangleClicked()
{
	worldtree->addTriangle();
}

void	MainWin::addHeightfieldClicked()
{
	worldtree->addHeightfield();
}

void	MainWin::addLightPointClicked()
{
	worldtree->addLightPoint();
}

void	MainWin::addSpotLightClicked()
{
	worldtree->addSpotLight();
}

void	MainWin::addAreaLightClicked()
{
	worldtree->addAreaLight();
}

void	MainWin::paintEvent(QPaintEvent *pe)
{
	KTopLevelWidget::paintEvent(pe);
}

void	MainWin::show()
{
	KTopLevelWidget::show();
	//call(QWidget::show());
	//call(KTopLevelWidget::updateRects());
}

void	MainWin::setViewMode(int buttonn)
{
	int	t;

	if(buttonn < 7)
	{
		for(t = 1;t < 7;t++)
			if(t != buttonn)
				tbview->setButton(t,false);

		tbview->setButton(buttonn,true);

		emit viewMode(buttonn);
	}
	else if(buttonn < 11)
	{
		for(t = 7;t < 11;t++)
			if(t != buttonn)
				tbview->setButton(t,false);

		tbview->setButton(buttonn,true);

		emit projectionMode(buttonn - 6);
	}
}

