#ifndef __DIMWIDGET__
#define __DIMWIDGET__

#include <stdio.h>

#include <qwidget.h>
#include <qlined.h>
#include <qlabel.h>

#include <matmath.h>

class DimWidget : public QWidget
{
Q_OBJECT
protected:
	Vector3		vs,vr,vt;

	QLineEdit	*le[9];
	QLabel		*la[3];

public:
	DimWidget(QWidget *p,char *n) :
		QWidget(p,n)
	{
		int		t;

		vs = Vector3(1,1,1);
		vr = Vector3(0,0,0);
		vt = Vector3(0,0,0);
		for(t = 0;t < 9;t++)
		{
			le[t] = new QLineEdit(this);
		}
		for(t = 0;t < 3;t++)
		{
			la[t] = new QLabel(this);
		}
	}
	~DimWidget()
	{
		int		t;

		for(t = 0;t < 9;t++)
		{
			delete le[t];
		}
		for(t = 0;t < 3;t++)
		{
			delete la[t];
		}
	}

	void	layout()
	{
		int		x,y,w,h,ww,hh;

		ww = width();
		hh = height();

		w = (ww - 10) / 4;
		h = 25;
		x = 5;
		y = 5;
		la[0]->move(x,y);
		la[0]->resize(w,h);
		la[0]->setText("Scale:");
		le[0]->move((x += w),y);
		le[0]->resize(w,h);
		le[1]->move((x += w),y);
		le[1]->resize(w,h);
		le[2]->move((x += w),y);
		le[2]->resize(w,h);

		x = 5;
		y += h + 5;
		la[1]->move(x,y);
		la[1]->resize(w,h);
		la[1]->setText("Rotate:");
		le[3]->move((x += w),y);
		le[3]->resize(w,h);
		le[4]->move((x += w),y);
		le[4]->resize(w,h);
		le[5]->move((x += w),y);
		le[5]->resize(w,h);

		x = 5;
		y += h + 5;
		la[2]->move(x,y);
		la[2]->resize(w,h);
		la[2]->setText("Transpose:");
		le[6]->move((x += w),y);
		le[6]->resize(w,h);
		le[7]->move((x += w),y);
		le[7]->resize(w,h);
		le[8]->move((x += w),y);
		le[8]->resize(w,h);

		load(vs,vr,vt);
	}

	void	load(Vector3 sv,Vector3 rv,Vector3 tv)
	{
		char		str[128];

		vs = sv;
		vr = rv;
		vt = tv;

		sprintf(str,"%g",vs[0]);
		le[0]->setText(str);
		sprintf(str,"%g",vs[1]);
		le[1]->setText(str);
		sprintf(str,"%g",vs[2]);
		le[2]->setText(str);

		sprintf(str,"%g",vr[0] * 180 / PI);
		le[3]->setText(str);
		sprintf(str,"%g",vr[1] * 180 / PI);
		le[4]->setText(str);
		sprintf(str,"%g",vr[2] * 180 / PI);
		le[5]->setText(str);

		sprintf(str,"%g",vt[0]);
		le[6]->setText(str);
		sprintf(str,"%g",vt[1]);
		le[7]->setText(str);
		sprintf(str,"%g",vt[2]);
		le[8]->setText(str);
	}
	void	save(Vector3 &sv,Vector3 &rv,Vector3 &tv)
	{
		float		d;
		const char	*str;

		str = le[0]->text();
		sscanf(str,"%g",&d);
		sv[0] = d;
		str = le[1]->text();
		sscanf(str,"%g",&d);
		sv[1] = d;
		str = le[2]->text();
		sscanf(str,"%g",&d);
		sv[2] = d;

		str = le[3]->text();
		sscanf(str,"%g",&d);
		rv[0] = d / 180 * PI;
		str = le[4]->text();
		sscanf(str,"%g",&d);
		rv[1] = d / 180 * PI;
		str = le[5]->text();
		sscanf(str,"%g",&d);
		rv[2] = d / 180 * PI;

		str = le[6]->text();
		sscanf(str,"%g",&d);
		tv[0] = d;
		str = le[7]->text();
		sscanf(str,"%g",&d);
		tv[1] = d;
		str = le[8]->text();
		sscanf(str,"%g",&d);
		tv[2] = d;

		vs = sv;
		vr = rv;
		vt = tv;
	}
};

#endif



