#include "dialogs.h"
#include "dialogs.moc"

#include <klocale.h>

#define stloc(a)	((char*)locale->translate((a)))

namedialog::namedialog(QWidget *parent=0,const char *name=0) :
	QDialog(parent,name,TRUE)
{
	KLocale	*locale;

	setCaption(name);

	locale = new KLocale();

	line = new QLineEdit(this);

	ok = new QPushButton( this,stloc("Ok"));
	ok->setText(stloc("OK"));
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );

	cancel = new QPushButton( this,stloc("Cancel") );
	cancel->setText(stloc("Cancel"));
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	setMaximumSize(150,65);
	QDialog::resize(150,65);
	setMinimumSize(150,65);

	line->setGeometry(5,5,140,25);
	cancel->setGeometry(5,35,67,25);
	ok->setGeometry(77,35,67,25);	

	delete locale;
}

namedialog::~namedialog()
{
	delete	ok;
	delete	cancel;
	delete	line;
}

QString	namedialog::getName()
{
	return line->text();
}

void	namedialog::setName(QString s)
{
	line->setText(s);
}

dimdialog::dimdialog(QWidget *parent,const char *name) :
	QDialog(parent,name,TRUE)
{
	KLocale	*locale;

	setCaption(name);

	dimw = new DimWidget(this,"");

	locale = new KLocale();

	ok = new QPushButton( this,stloc("Ok"));
	ok->setText(stloc("OK"));
	connect( ok, SIGNAL(clicked()), SLOT(accept()) );

	cancel = new QPushButton( this,stloc("Cancel") );
	cancel->setText(stloc("Cancel"));
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	setMaximumSize(300,140);
	QDialog::resize(300,140);
	setMinimumSize(300,140);

	dimw->setGeometry(0,0,300,125);
	cancel->setGeometry(67,110,80,25);
	ok->setGeometry(153,110,80,25);	

	delete locale;

	dimw->layout();
}

dimdialog::~dimdialog()
{
	delete	ok;
	delete	cancel;
	delete	dimw;
}

void	dimdialog::save(Vector3 &s,Vector3 &r,Vector3 &t)
{
	dimw->save(s,r,t);
}

void	dimdialog::load(Vector3 s,Vector3 r,Vector3 t)
{
	dimw->load(s,r,t);
}




TextureDialog::TextureDialog(QWidget *parent,const char *name,texture *t) :
	QDialog(parent,name,TRUE)
{
	QColor		qc;

	txtptr = t;

	qc.setRgb((int)(t->red() * 255),(int)(t->green() * 255),(int)(t->blue() * 255));

	colorlabel = new QLabel(this);
	colorlabel->setText("Color");

	colorbt = new KColorButton(qc,this);

	namelabel = new QLabel(this);
	namelabel->setText("Name:");

	line = new QLineEdit(this);

	ok = new QPushButton( this,"Ok");
	ok->setText("OK");
	connect( ok, SIGNAL(clicked()), SLOT(accept()));

	cancel = new QPushButton( this,"Cancel");
	cancel->setText("Cancel");
	connect( cancel, SIGNAL(clicked()), SLOT(reject()));


	resize(230,105);

	namelabel->setGeometry(5,5,80,25);
	line->setGeometry(85,5,140,25);
	colorlabel->setGeometry(5,35,80,25);
	colorbt->setGeometry(85,35,35,25);
	ok->setGeometry(35,75,75,25);
	cancel->setGeometry(120,75,75,25);	
}

TextureDialog::~TextureDialog()
{
	delete	colorbt;
	delete	colorlabel;
	delete	ok;
	delete	cancel;
	delete	line;
	delete	namelabel;
}

texture	*TextureDialog::getTexture()
{
	double	r,g,b;

	r = colorbt->color().red() / 255.0;
	g = colorbt->color().green() / 255.0;
	b = colorbt->color().blue() / 255.0;

	txtptr->setColor(r,g,b);
	txtptr->setName((char*)line->text());

	return txtptr;
}


