#ifndef __WORLD__
#define __WORLD__

#include "base.h"
#include "csgobj.h" 
#include "blobobj.h" 
#include "nonsolid.h" 
#include "refptr.h" 
#include "ref.h"

class world : public base
{
protected:
	list<ref*>	referencelist;
	list<body*>	objectlist; 

public:
	world(char *n = "Untitled");
	~world(); 
 
	virtual void	dumpNames(int tabsize = 2); 
	virtual void	dumpNames(int,int); 
 
	virtual int	save(FILE*); 
	virtual int	load(FILE*,int); 
 
	virtual int	exportPOV(FILE*,int tab,int tabsize); 

	virtual int	addToParent(base *parent);
	virtual int	removeFromParent();

	virtual int	addChild(body *child);
	virtual int	addChild(csgobj *child);
	virtual int	addChild(blobobj *child);
	virtual int	addChild(nonsolid *child);
	virtual int	addChild(refptr *child);
	virtual int	addChild(ref *child);

	virtual int	removeChild(base *child);
	virtual int	removeChild(body*); 
	virtual int	removeChild(refptr*); 
	virtual int	removeChild(ref*); 
	virtual int	removeChild(csgobj*); 
	virtual int	removeChild(blobobj*); 
//	virtual int	removeChild(sphere*) {return -1;}; 
//	virtual int	removeChild(cylinder*) {return -1;}; 
	virtual int	removeChild(nonsolid*);  

	virtual void	getChildren(base ***b)
	{
		int	t,i;
		base	**bt;

		*b = NULL;
		bt = (base**)malloc(sizeof(void*) * (objectlist.length() + referencelist.length() + 1));
		if(!bt) return;

		for(t = 0;t < referencelist.length();t++)
			bt[t] = referencelist[t];
		for(i = 0;i < objectlist.length();i++)
			bt[t + i] = objectlist[i];
		bt[t + i] = NULL;
		*b = bt;
	}

	virtual int	existsName(char *n);
	virtual base	*searchName(char *n);

	virtual int	draw(view*,Matrix44); 
};

#endif

