#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "world.h"

world::world(char *n) :
	base(NULL,n)
{
	numtype = NUM_WORLD;

	objectlist.setErrorValue(NULL);

	referencelist.setErrorValue(NULL);
}

world::~world()
{
	body	*d;
	ref	*r;

	for(d = objectlist.getFirst();d != NULL;d = ++objectlist) 
	{ 
		delete d; 
	} 
	for(r = referencelist.getFirst();r != NULL;r = ++referencelist) 
	{ 
		delete r; 
	} 
} 
 
int	world::exportPOV(FILE *fp,int tab,int tabsize)
{
	body	*b;
	ref	*r;

	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab); 
	fprintf(fp,"// Objecttype = world\n\n\n"); 

	for(r = referencelist.getFirst();r != NULL;r = ++referencelist)
	{
		fprintf(fp,"#declare %s =\n",r->getName());
		r->exportPOV(fp,tab + tabsize,tabsize);
		fprintf(fp,"\n");
		referencelist.find(r);
	}

	for(b = objectlist.getFirst();b != NULL;b = ++objectlist)
	{
		b->exportPOV(fp,tab,tabsize);
		objectlist.find(b);
	}
	
	return 0;
}

void	world::dumpNames(int tab,int tabsize)
{
	ref	*r;
	body	*b;

	printTab(stdout,tab);
	printf("world: %s\n",name);

	for(r = referencelist.getFirst();r != NULL;r = ++referencelist) 
	{ 
		r->dumpNames(tab + tabsize,tabsize); 
		referencelist.find(r);
	} 
 
	for(b = objectlist.getFirst();b != NULL;b = ++objectlist) 
	{ 
		b->dumpNames(tab + tabsize,tabsize); 
		objectlist.find(b);
	} 
}

void	world::dumpNames(int tabsize)
{
	dumpNames(0,tabsize);
}

int	world::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);

	writeChunk("WRLD");

	SN(name);

	ref	*r;
	body	*b;

	for(r = referencelist.getFirst();r != NULL;r = ++referencelist) 
	{ 
		r->save(fp); 
		referencelist.find(r);
	} 
 
	for(b = objectlist.getFirst();b != NULL;b = ++objectlist) 
	{ 
		b->save(fp); 
		objectlist.find(b);
	} 
	
	writeChunkLen();

	return 0;
}

int	world::load(FILE *fp,int l)
{
	int	pos = ftell(fp);
	base	*b;

	while(ftell(fp) < pos + l)
	{
		b = parse(fp);
		if(b)
		{
			b->addToParent(this);
			b->setParent(this);
		}
	}

	return 0;
}

int	world::addToParent(base *parent)
{
	if(!parent) return -2;
	return parent->addChild(this);
}

int	world::removeFromParent()
{
	if(!parent) return -2;
	return parent->removeChild(this);
}

int	world::addChild(body *child)
{
	if(!child) return -1;
	return objectlist += child;
}

int	world::addChild(blobobj *child)
{
	if(!child) return -1;
	return objectlist += child;
}

int	world::addChild(csgobj *child)
{
	if(!child) return -1;
	return objectlist += child;
}

int	world::addChild(nonsolid *child)
{
	if(!child) return -1;
	return objectlist += child;
}

int	world::addChild(refptr *child)
{
	if(!child) return -1;
	return objectlist += child;
}

int	world::addChild(ref *child)
{
	if(!child) return -1;
	return referencelist += child;
}

int	world::removeChild(base *child)
{
	if(!child) return -1;
	if(child->getType() == NUM_REF)
	{
		if(referencelist.find((ref*)child) < 0) return -2;
		referencelist.deleteCurrent();
		return 0;
	}
	if(objectlist.find((body*)child) < 0) return -2;
	objectlist.deleteCurrent();

	return 0;
}

int	world::removeChild(body *child)
{
	if(!child) return -1;

	if(objectlist.find((body*)child) < 0) return -2;
	objectlist.deleteCurrent();

	return 0;
}

int	world::removeChild(refptr *child)
{
	if(!child) return -1;

	if(objectlist.find((body*)child) < 0) return -2;
	objectlist.deleteCurrent();

	return 0;
}

int	world::removeChild(ref *child)
{
	if(!child) return -1;
	if(referencelist.find((ref*)child) < 0) return -2;
	referencelist.deleteCurrent();
	return 0;
}

int	world::removeChild(csgobj *child)
{
	if(!child) return -1;

	if(objectlist.find((body*)child) < 0) return -2;
	objectlist.deleteCurrent();

	return 0;
}

int	world::removeChild(blobobj *child)
{
	if(!child) return -1;

	if(objectlist.find((body*)child) < 0) return -2;
	objectlist.deleteCurrent();

	return 0;
}

int	world::removeChild(nonsolid *child)
{
	if(!child) return -1;

	if(objectlist.find((body*)child) < 0) return -2;
	objectlist.deleteCurrent();

	return 0;
}

int	world::existsName(char *n)
{
	body	*d;
	ref	*r;

	if(n == NULL) return -1;

	if(name != NULL && strcmp(name,n) == 0)
		return !0;

	for(d = objectlist.getFirst();d != NULL;d = ++objectlist)
	{
		if(d->existsName(n)) return !0;
		objectlist.find(d);
	}

	for(r = referencelist.getFirst();r != NULL;r = ++referencelist)
	{
		if(r->existsName(n)) return !0;
		referencelist.find(r);
	}

	return 0;
}

base	*world::searchName(char *n)
{
	body	*d;
	ref	*r;
	base	*b;

	if(n == NULL) return NULL;

	if(name != NULL && strcmp(name,n) == 0)
		return this;

	for(d = objectlist.getFirst();d != NULL;d = ++objectlist)
	{
		if((b = d->searchName(n))) return b;
		objectlist.find(d);
	}

	for(r = referencelist.getFirst();r != NULL;r = ++referencelist)
	{
		if((b = r->searchName(n))) return b;
		referencelist.find(r);
	}

	return NULL;
}

int	world::draw(view *v,Matrix44 m)
{
	body	*d;
//	ref	*r;
	int	t;

	if(v == NULL) return -1;

	for(t = 0;t < objectlist.length();t++)
	{
		d = objectlist[t];
		d->draw(v,m);
	}

/*
	for(r = referencelist.getFirst();r != NULL;r = ++referencelist)
	{
		if((b = r->searchName(n))) return b;
		referencelist.find(r);
	}
*/

	return 0;
}

