#ifndef __VIEW_H__
#define __VIEW_H__


#include "matmath.h"

#include "world.h"

#define EPSILON	1e-100


class view
{
public:
	typedef enum
	{
		SPACE = 1,
		PARALLEL_XY,
		PARALLEL_XZ,
		PARALLEL_ZY,
	}
	PROJECTION;

protected:

	Matrix44	mview,mscreen;
	Vector3		peye;
	Vector3		vview;
	Vector3		vright;
	Vector3		vup;
	double		fov,aspect_ratio;
	int		w,h;

	int		projmode;	

	world		*worldptr;
	base		*selectedptr;
	int		drawselected;

public:

	view();
	//~view();

	int		setWorld(world *wp);
	int		setEye(Vector3 p);
	int		setLookAt(Vector3 p);
	int		setUp(Vector3 p);
	int		setRight(Vector3 p);

	int		setFOV(double d);
	int		setAspectRatio(double d);
	int		setScreen(int,int);

	int		project(Vector3 v,Vector2 &xy,Matrix44 m);


	void		setProjectionMode(int pm)
	{
		projmode = pm;
	}

	void		setSelected(base *bp)
	{
		selectedptr = bp;
	}
	base		*getSelected()
	{
		return selectedptr;
	}
	void		setDrawSelected(int sel)
	{
		drawselected = sel;
	}

	virtual int	drawLine(Vector3,Vector3,Matrix44) = 0;
	virtual int	drawCross(Vector3,Matrix44) = 0;
	virtual int	drawTriangle(Vector3,Vector3,Vector3,Matrix44) = 0;
	virtual int	drawTrapezium(Vector3,Vector3,Vector3,Matrix44) = 0;
	virtual int	drawCircle(Vector3,Vector3,Vector3,Matrix44) = 0;

	virtual int	drawSphere(Vector3,Vector3,Vector3,Vector3,Matrix44) = 0;
	virtual int	drawSemiSphere(Vector3,Vector3,Vector3,Vector3,Matrix44) = 0;
	virtual int	drawBox(Vector3,Vector3,Vector3,Vector3,Matrix44) = 0;
	virtual int	drawCone(Vector3,Vector3,Vector3,Vector3,double,Matrix44) = 0;
	virtual int	drawCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44) = 0;
	virtual int	drawTorus(Vector3,Vector3,Vector3,Vector3,double,Matrix44) = 0;

	virtual int	drawSymbol(Vector3,const char*,Matrix44) = 0;

	int		exportPOV(FILE *,int);

protected:

	void	createView();
	void	createScreen(int w,int h);
	void	calcVectors();

	void	printTab(FILE *fp,int tab);
};


#endif

