#include "view.h"

view::view()
{
	peye = Vector3(0,0,1000);
	vview = Vector3(0,0,-1000);
	vup = Vector3(0,1,0);
	vright = Vector3(1,0,0);

	fov = 0.3;
	aspect_ratio = 1;

	worldptr = NULL;
	selectedptr = NULL;

	drawselected = 0;

	projmode = SPACE;

	calcVectors();
	createView();
	createScreen(100,100);
};

int	view::setWorld(world *wp)
{
	worldptr = wp;
	return 0;
}

int		view::setEye(Vector3 p)
{
	peye = p;

	calcVectors();

	return 0;
}

int		view::setLookAt(Vector3 p)
{
	vview = p - peye;

	calcVectors();

	return 0;
}

int		view::setUp(Vector3 p)
{
	vup = p;

	calcVectors();

	return 0;
}
int		view::setRight(Vector3 p)
{
	vright = p;

	calcVectors();

	return 0;
}

int		view::setFOV(double d)
{
	fov = d;

	if(fov < 0.005) fov = 0.005;
	if(fov > 89.999999 / 180 * PI) fov = 89.999999 / 180 * PI;

	calcVectors();

	return 0;
}

int		view::setAspectRatio(double d)
{
	aspect_ratio = d;

	calcVectors();

	return 0;
}

int		view::setScreen(int ww,int hh)
{
	w = ww;
	h = hh;

	calcVectors();

	return 0;
}

void		view::calcVectors()
{
	double		d,a;

	d = tan(fov / 2) * vview.length();
	a = (double)w / (double)h * aspect_ratio;
	
	vright.normalize();
	vright *= d * a;
	vup.normalize();
	vup *= d;

	createView();
}


int		view::project(Vector3 v,Vector2 &xy,Matrix44 m)
{
	switch(projmode)
	{
		case SPACE:
		{
			Vector4	v4,vh;

			v4 = v;

			v4 *= m;
			v4 *= mview;
			vh = v4;
			v4 *= mscreen;

			if((vh(2)) < EPSILON) return -1;

			xy(0) = v4(0) / vh(2);
			xy(1) = v4(1) / vh(2);

			//xy.print();
		}
		break;
		case PARALLEL_XY:
		{
			Vector4	v4;

			v4 = v;
			v4 *= m;
			v4 /= tan(fov) / 1.4;

			xy(0) = (w / 2) + v4(0);
			xy(1) = (h / 2) - v4(1);

			//xy.print();
		}
		break;
		case PARALLEL_XZ:
		{
			Vector4	v4;

			v4 = v;
			v4 *= m;
			v4 /= tan(fov) / 1.4;

			xy(0) = (w / 2) + v4(0);
			xy(1) = (h / 2) - v4(2);

			//xy.print();
		}
		break;
		case PARALLEL_ZY:
		{
			Vector4	v4;

			v4 = v;
			v4 *= m;
			v4 /= tan(fov) / 1.4;

			xy(0) = (w / 2) + v4(2);
			xy(1) = (h / 2) - v4(1);

			//xy.print();
		}
		break;
	}

	return 0;
}

void	view::createView()
{
	Matrix44	mh;

	mview(0,0) = vright(0);
	mview(0,1) = vup(0);
	mview(0,2) = vview(0);
	mview(0,3) = peye(0);
	mview(1,0) = vright(1);
	mview(1,1) = vup(1);
	mview(1,2) = vview(1);
	mview(1,3) = peye(1);
	mview(2,0) = vright(2);
	mview(2,1) = vup(2);
	mview(2,2) = vview(2);
	mview(2,3) = peye(2);
	mview(3,0) = 0;
	mview(3,1) = 0;
	mview(3,2) = 0;
	mview(3,3) = 1;
	mh = mview;
	mview = ~mh;
}

void	view::createScreen(int w,int h)
{
	mscreen.unify();
	mscreen(0,0) = ((double)w - 1) / -2;
	mscreen(0,2) = ((double)w - 1) / 2;
	mscreen(1,1) = ((double)h - 1) / -2;
	mscreen(1,2) = ((double)h - 1) / 2;
}

int	view::exportPOV(FILE *fp,int tabsize)
{
	Vector3		v;
	int		tab = tabsize;

	fprintf(fp,"// Objectname = camera\n"); 
	fprintf(fp,"// Objecttype = view\n\n\n"); 

	fprintf(fp,"camera\n");
	fprintf(fp,"{\n");

	printTab(fp,tab); 
	fprintf(fp,"location  <%g,%g,%g>\n",peye[0],peye[1],peye[2]);
	printTab(fp,tab); 
	fprintf(fp,"sky       <%g,%g,%g>\n",vup[0],vup[1],vup[2]);

//	printTab(fp,tab); 
//	fprintf(fp,"direction <%g,%g,%g>\n",vview[0],vview[1],vview[2]);

	v = peye + vview;

	printTab(fp,tab); 
	fprintf(fp,"look_at    <%g,%g,%g>\n",v[0],v[1],v[2]);

	v = vup * 2;

	printTab(fp,tab); 
	fprintf(fp,"up         <%g,%g,%g>\n",v[0],v[1],v[2]);

	v = vright * -2;

	printTab(fp,tab); 
	fprintf(fp,"right      <%g,%g,%g>\n",v[0],v[1],v[2]);

	fprintf(fp,"}\n\n");

	return 0;
}

void	view::printTab(FILE *fp,int tab)
{
	int	t;

	for(t = 0;t < tab;t++)
	{
		fprintf(fp," ");
	}
}





