#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "triangle.h"
#include "num.h"

triangle::triangle(base *p,char *n,double x1, double y1, double z1,double x2, double y2, double z2,double x3, double y3, double z3, int s ) :
	nonsolid(p,n)
{
	numtype = NUM_TRIANGLE;
	edge1 = Vector3(x1,y1,z1);
	edge2 = Vector3(x2,y2,z2);
	edge3 = Vector3(x3,y3,z3);
	n1 = Vector3(0,0,0);
	n2 = Vector3(0,0,0);
	n3 = Vector3(0,0,0);
	smooth=s;
	if (parent) addToParent(parent);
}

triangle::triangle(base *p, char *n, Vector3 v1, Vector3 v2, Vector3 v3)
:
	nonsolid(p,n)
{
	numtype = NUM_TRIANGLE;
	edge1=v1;
	edge2=v2;
	edge3=v3;
}

triangle::~triangle()
{
	removeFromParent();
}

int	triangle::SetNormal(Vector3 v1, Vector3 v2, Vector3 v3,int s)
{
	n1=v1;
	n2=v2;
	n3=v3;
	smooth=s;

	return 0;
}

int	triangle::SetNormal(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, int s)
{
	n1 = Vector3(x1,y1,z1);
	n2 = Vector3(x2,y2,z2);
	n3 = Vector3(x3,y3,z3);
	smooth=s;

	return 0;
}

int	triangle::addToParent(base *p)
{
	if (!p) return -2;
	parent = p;
	return p->addChild(this);
}

int triangle::removeFromParent() 
{ 
	if (!parent) return -2;
	return parent->removeChild(this); 
}

void triangle::dumpNames(int tab, int)
{
	printTab(stderr,tab);
	printf("triangle: %s\n",name);
}

int	triangle::exportPOV(FILE *fp,int tab,int tabsize )
{
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = triangle\n");

	printTab(fp,tab);
	if (smooth==0) {fprintf(fp,"triangle {\n"); } else { fprintf(fp,"smooth_triangle {\n");}
	printTab(fp,tab+tabsize);
	fprintf(fp,"<%f, %f, %f>, ",edge1[0],edge1[1],edge1[2]);
	if (smooth==1) { fprintf(fp,"<%f, %f, %f>, ",n1[0],n1[1],n1[2]);}
	fprintf(fp,"\n");
	printTab(fp,tab+tabsize);
	fprintf(fp,"<%f, %f, %f>, ",edge2[0],edge2[1],edge2[2]);
	if (smooth==1) { fprintf(fp,"<%f, %f, %f>, ",n1[0],n1[1],n1[2]);}
	fprintf(fp,"\n");
	printTab(fp,tab+tabsize);
	fprintf(fp,"<%f, %f, %f> ",edge3[0],edge3[1],edge3[2]);
	if (smooth==1) { fprintf(fp,", <%f, %f, %f> ",n1[0],n1[1],n1[2]);}
	fprintf(fp,"\n");

	exportPOV(fp,tab,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");	

	return 0;
}

int triangle::save(FILE *fp)
{
	if (!fp) return -1;
	setFile(fp);
	
	if (smooth==1) {
		writeChunk("TRIA");
		SN(name);
		SV(edge1);
		SV(edge2);
		SV(edge3);
		SI(1);
		SV(n1);
		SV(n2);
		SV(n3);
	} else {
		writeChunk("TRIA");
		SN(name);
		SV(edge1);
		SV(edge2);
		SV(edge3);
		SI(0);
	}
	dim::save(fp);
	writeChunkLen();
	return 0;
}

int triangle::load(FILE *fp,int l)
{
	edge1 = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
	edge2 = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
	edge3 = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
	smooth=readInt(fp);
	if (smooth==1) {
		n1 = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
		n2 = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
		n3 = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
	}
	dim::load(fp,l);

	return 0;
}
