#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "torus.h"
#include "num.h"
#include "view.h" 

torus::torus(base *p,char *n, double r1,double r2) :
	csgobj(p,n)
{
	numtype = NUM_TORUS;
	major=r1;
	minor=r2;
	if(parent) addToParent(parent);
}

torus::~torus()
{
}

int	torus::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	torus::removeFromParent()
{
	if(!parent) return -2;

	return parent->removeChild(this);
}

void	torus::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("torus: %s\n",name);
}

int	torus::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = torus\n");
	printTab(fp,tab);
	fprintf(fp,"torus\n");
	printTab(fp,tab); 
	fprintf(fp,"{\n"); 
	printTab(fp,tab + tabsize); 
	fprintf(fp,"%f, %f\n",major,minor); 
	
	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	torus::save(FILE *fp)
{
	setFile(fp);
	writeChunk("TRUS");
	SN(name);
	SD(major);
	SD(minor);
	dim::save(fp);
	writeChunkLen();


	return 0;
}

int	torus::load(FILE *fp,int l)
{
	fread(&major,1,sizeof(double),fp);
	fread(&minor,1,sizeof(double),fp);

	dim::load(fp,l - 2 * sizeof(double));

	return 0;
}

int	torus::draw(view *v,Matrix44 m)
{
	Vector3	p,vx,vy,vz;

	//printf("Torus\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(major,0,0);
	vy = Vector3(0,minor,0);
	vz = Vector3(0,0,major);

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawTorus(p,vx,vy,vz,minor,m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}



