#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "text.h"
#include "num.h"

text::text(base *p,char *n, char *txt, char *fnt, double th, double offs) :
	csgobj(p,n)
{
	numtype = NUM_TEXT;
	fontname=strdup(fnt);
	context=strdup(txt);
	thickness=th;
	offset=offs;

	if(parent) addToParent(parent);
}

text::~text()
{
	if (fontname)
		free(fontname);
	if (context)
		free(context);
}

int	text::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	text::removeFromParent()
{
	if(!parent) return -2;

	return parent->removeChild(this);
}

void	text::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("test: %s\n",name);
}

int	text::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = text\n");
	printTab(fp,tab);
	fprintf(fp,"text\n");
	printTab(fp,tab); 
	fprintf(fp,"{\n"); 
	printTab(fp,tab + tabsize); 
	fprintf(fp,"ttf \"%s\", \n",fontname); 
	printTab(fp,tab + tabsize);
	fprintf(fp,"\"%s\",\n", context);
	printTab(fp,tab + tabsize);
	fprintf(fp,"%f %f\n",thickness, offset);
	
	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	text::save(FILE *fp)
{
	setFile(fp); 
	writeChunk("TEXT");
	SN(name);
	SN(fontname);
	SN(context);
	SD(thickness);
	SD(offset);
	writeChunkLen();
	
	return 0;
}

int	text::load(FILE *fp,int l)
{
	fontname = readName(fp);
	context = readName(fp);
	fread(&thickness,1,sizeof(double),fp);
	fread(&offset,1,sizeof(double),fp);

	dim::load(fp,l - 2 * sizeof(double));

	return 0;
}


