#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "superellipsoid.h"
#include "num.h"

superellipsoid::superellipsoid(base *p,char *na,double a, double b) :
	csgobj(p,na)
{
	numtype = NUM_SUPERELLIPSOID;
	e=a;n=b;
	if(parent) addToParent(parent);
}

superellipsoid::~superellipsoid()
{
}

int	superellipsoid::addToParent(base *p)
{
	if(!p) return -2;

	return p->addChild(this);
}

int     superellipsoid::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = superellipsoid\n");

	printTab(fp,tab);
	fprintf(fp,"sphere\n");
	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	fprintf(fp,"<%f, %f> \n",e,n);
	
	dim::exportPOV(fp,tab + tabsize,tabsize);
	
	printTab(fp,tab); 
	fprintf(fp,"}\n\n");

	return 0;
}

void	superellipsoid::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("superellipsoid: %s\n",name); 
}


int	superellipsoid::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);
	writeChunk("SELL");
	SN(name);
	SD(e);SD(n);
	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	superellipsoid::load(FILE *fp,int l)
{
	e=readDouble(fp);
	n=readDouble(fp);
	dim::load(fp,l);

	return 0;
}


