#ifndef __SPOTLIGHT__
#define __SPOTLIGHT__

#include <stdio.h>
#include "lightobj.h"


class spotlight : public lightobj
{
public:
	double r,g,b;
	double fade_distance;		
	double fade_power;
	int atmos_attenuation;
	Vector3 point_at;
	double radius, falloff, tightness;
	

	spotlight(base *p=NULL, char *n="Untitled");
	~spotlight();
	
	void SetColor(double, double, double);
	void SetFadeDistance(double);
	void SetFadePower(double);
	void SetAtmosAtt(int);
	void SetPointAt(Vector3 );
	void SetPointAt(double, double, double);
	void SetTightness(double);
	void SetRadius(double);
	void SetFallOff(double);

	virtual int	addToParent(base *p);
	virtual int	removeFromParent();

	virtual int	exportPOV(FILE *f, int tab, int tabsize);
	virtual void	dumpNames(int tab, int tabsize);

	virtual int	save(FILE *);
	virtual int	load(FILE *, int);

	virtual int	draw(view*,Matrix44);
};

#endif	
