#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "spotlight.h"
#include "num.h"
#include "view.h"

spotlight::spotlight(base *p,char *n) :
	lightobj(p,n)
{
	numtype = NUM_SPOTLIGHT;
	r=1;g=1;b=1;
	fade_distance=0;
	fade_power=0;
	atmos_attenuation=0;
	point_at = Vector3(1,1,1);
	falloff=0;
	tightness=0;
	radius=5;	
	if(parent) addToParent(parent);
}

spotlight::~spotlight()
{
	removeFromParent();
}

void spotlight::SetColor(double c1, double c2, double c3)
{
	r=c1;g=c2;b=c3;
}

void spotlight::SetFadeDistance(double d)
{
	fade_distance=d;
}

void spotlight::SetFadePower(double p)
{
	fade_power=p;
}

void spotlight::SetAtmosAtt(int a)
{
	atmos_attenuation=a;
}

void spotlight::SetPointAt(Vector3 v)
{
	point_at=v;
}

void spotlight::SetPointAt(double x, double y, double z)
{
	point_at = Vector3(x,y,z);
}

void spotlight::SetTightness(double t)
{
	tightness=t;
}

void spotlight::SetRadius(double r)
{
	radius=r;
}

void spotlight::SetFallOff(double f)
{
	falloff=f;
}

int	spotlight::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int 	spotlight::removeFromParent()
{
	if (!parent) return -2;
	return parent->removeChild(this);
}
 
int     spotlight::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = light_point\n");

	printTab(fp,tab);
	fprintf(fp,"light_source\n");
	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	fprintf(fp,"<0, 0, 0>\n");
	printTab(fp,tab + tabsize); 
	fprintf(fp,"color rgb<%f, %f, %f> \n",r,g,b); 
	printTab(fp,tab+tabsize);
	fprintf(fp,"spotlight\n");
	printTab(fp,tab+tabsize);
	fprintf(fp,"radius %f\n",radius);
	printTab(fp,tab+tabsize);
	fprintf(fp,"falloff %f\n",falloff);
	printTab(fp,tab+tabsize);
	fprintf(fp,"tightness %f\n", tightness);
	printTab(fp,tab+tabsize);
	fprintf(fp,"fade_distance %f \n",fade_distance);
	printTab(fp, tab+tabsize);
	fprintf(fp,"fade_power %f \n",fade_power);
	printTab(fp, tab+tabsize);
	if (atmos_attenuation==1) {fprintf(fp,"atmospheric_attenuation TRUE\n");}
	
	dim::exportPOV(fp,tab + tabsize,tabsize);
	
	printTab(fp,tab); 
	fprintf(fp,"}\n\n");

	return 0;
}

void	spotlight::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("spotlight: %s\n",name); 
}


int	spotlight::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);
	writeChunk("SPTL");
	SN(name);

	SD(r);SD(g);SD(b);
	SV(point_at);
	SD(radius);
	SD(falloff);
	SD(tightness);
	SD(fade_distance);
	SD(fade_power);
	SI(atmos_attenuation);

	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	spotlight::load(FILE *fp,int l)
{
	r=readDouble(fp);
	g=readDouble(fp);
	b=readDouble(fp);	
	point_at = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
	radius=readDouble(fp);
	falloff=readDouble(fp);
	tightness=readDouble(fp);
	fade_distance=readDouble(fp);
	fade_power=readDouble(fp);
	atmos_attenuation=readInt(fp);	

	dim::load(fp,l);
	return 0;
}

int	spotlight::draw(view *v,Matrix44 m)
{
	Vector3	p;

	v->drawSymbol(p,name,m);

	return 0;
}

