#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sphere.h"
#include "num.h"

#include "view.h"


sphere::sphere(base *p,char *n,double st) :
	blobobj(p,n,st)
{
	numtype = NUM_SPHERE;

	if(parent) addToParent(parent);
}

sphere::~sphere()
{
	removeFromParent();
}

int	sphere::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	sphere::removeFromParent() 
{ 
	if(!parent) return -2; 
 
	return parent->removeChild(this); 
} 
 
int	sphere::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = sphere\n");

	printTab(fp,tab);
	fprintf(fp,"sphere\n");
	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	fprintf(fp,"<0,0,0>,0.5");

	if (!isBlobObject())
		fprintf(fp,"\n"); 
	else
		fprintf(fp,",%f\n",strength);
	
	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);
	
	printTab(fp,tab); 
	fprintf(fp,"}\n\n");

	return 0;
}

void	sphere::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("sphere: %s\n",name); 
}

int	sphere::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);
	writeChunk("SPHR");
	SN(name);
	fwrite(&strength,1,sizeof(double),fp);
	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	sphere::load(FILE *fp,int l)
{
	fread(&strength,1,sizeof(double),fp);

	dim::load(fp,l);

	return 0;
}

int	sphere::draw(view *v,Matrix44 m)
{
	Vector3	p,vx,vy,vz;

	//printf("Sphere\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(0.5,0,0);
	vy = Vector3(0,0.5,0);
	vz = Vector3(0,0,0.5);

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawSphere(p,vx,vy,vz,m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}



