#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "script.h"

script::script(base *p,char *n,char *t) :
	nonsolid(p,n)
{
	numtype = NUM_SCRIPT;
	if(t) textdata = strdup(t);
	if(parent) addToParent(parent);
}

script::~script()
{
	if(textdata)
	{
		free(textdata);
	}
}

void	script::setText(char *t)
{
	if(textdata) free(textdata);

	textdata = strdup(t);
}

char	*script::getText()
{
	return textdata;
}

void	script::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("script %s\n",name);
}

int	script::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	char	*cp,*tmpstr; 
 
	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = script\n");

	printTab(fp,tab);
	fprintf(fp,"{\n");

	if(textdata)
	{
		tmpstr = strdup(textdata);
		for(cp = strtok(tmpstr,"\n");cp != NULL;cp = strtok(NULL,"\n"))
		{
			printTab(fp,tab + tabsize);
			while(*cp == ' ' || *cp == '\t') cp++;
			fprintf(fp,"%s\n",cp);
		}
		free(tmpstr);
	}

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	script::save(FILE *fp)
{
	int	l;

	setFile(fp);
	writeChunk("SCPT");
	SN(name);
	l = strlen(textdata);
	fwrite(&l,1,4,fp);
	fwrite(textdata,1,l,fp);
	dim::save(fp);
	writeChunkLen();
	
	return 0;
}

int	script::load(FILE *fp,int l)
{
	textdata = readName(fp);

	dim::load(fp,l);

	return 0;
}


