#include <stdio.h>
#include <stdlib.h>

#include "refptr.h"

refptr::refptr(base *p,char *n) :
	atom(p,n)
{
	numtype = NUM_REFPTR;
	refp = NULL;
	tmpname = NULL;

	if(parent)
		addToParent(parent);
}

refptr::~refptr()
{
	removeFromParent();
}

int	refptr::addToParent(base *b)
{
	if(!b) return -2;

	parent = b;
	return b->addChild(this);
}

int	refptr::removeFromParent()
{
	if(!parent) return -2;

	return parent->removeChild(this);
}

int	refptr::addChild(ref *r)
{
	if(!r) return -2;

	refp = r;

	return 0;
}

void	refptr::getChildren(base ***b)
{
	base	**bt;

	*b = NULL;
	bt = (base**)malloc(sizeof(void*) * 2);
	if(!bt) return;

	bt[0] = refp;
	bt[1] = NULL;
	*b = bt;
}

int	refptr::exportPOV(FILE *fp,int tab,int tabsize)
{
	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(refp)
		{
			if(tmpname) free(tmpname);
			tmpname = NULL;
		}
	}
	if(!refp && !tmpname) return -1;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = refptr\n");

	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	if(refp)
		fprintf(fp,"object{%s}\n",refp->getName());
	else if(tmpname)
		fprintf(fp,"object{%s}\n",tmpname);

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

void	refptr::dumpNames(int tab,int tabsize)
{
	printTab(stdout,tab);
	printf("refptr: %s\n",name);

	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(!refp) return;
		if(tmpname) free(tmpname);
		tmpname = NULL;
	}
	refp->dumpNames(tab + tabsize,tabsize);
}

int	refptr::save(FILE *fp)
{
	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(!refp) return -1;
		if(tmpname) free(tmpname);
		tmpname = NULL;
	}

	setFile(fp);
	writeChunk("REFP");
	SN(name);
	SN(refp->getName());
	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	refptr::load(FILE *fp,int l)
{
	int	len = 0;

	tmpname = readName(fp);
	printf("RefPTR: %s\n",tmpname);
/*
	if(tmpname)
	{
		root = getRoot();
		refp = (ref*)(root->searchName(tmpname));
		len = strlen(tmpname);
		if(refp && tmpname) free(tmpname);
	}
*/
	dim::load(fp,l - len - 4);

	return 0;
}

base	*refptr::getPTR()
{
	if(!refp && tmpname)
	{
		base	*root;

		root = getRoot();
		refp = (ref*)(root->searchName(tmpname));
		if(refp && tmpname) free(tmpname);
	}
		
	return refp;
}

char	*refptr::getPTRName()
{
	if(refp) return refp->getName();
	if(tmpname) return tmpname;

	return NULL;
}

int	refptr::draw(view *v,Matrix44 m)
{
	if(!refp)
	{
		if(tmpname)
		{
			refp = (ref*)(getRoot()->searchName(tmpname));
		}

		if(!refp) return -2;
		if(tmpname) free(tmpname);
		tmpname = NULL;
	}
	return refp->draw(v,m);
}


