#ifndef __REF__
#define __REF__

#include "base.h"

#include "body.h"
#include "refptr.h"
#include "csgobj.h"
#include "blobobj.h"
#include "nonsolid.h"

class ref : public base
{
protected:
	list<refptr*>	reflist;
	list<body*>	objectlist;

public:
	ref(base *p = NULL,char *n = "Untitled");

	int		getReferenceCounter() {	return reflist.length();};

	virtual int	addToParent(base*);
	virtual int	removeFromParent();
	virtual int	addChild(body*);
	virtual int	addChild(refptr*);
	virtual int	addChild(csgobj*);
	virtual int	addChild(blobobj*);
	virtual int	addChild(nonsolid*);
	virtual int	removeChild(body*);
	virtual int	removeChild(refptr*);
	virtual int	removeChild(csgobj*);
	virtual int	removeChild(blobobj*);
	virtual int	removeChild(nonsolid*);

	virtual void	getChildren(base***);

	virtual int	exportPOV(FILE*,int,int);

	virtual void	dumpNames(int,int);

	virtual int	existsName(char*);
	virtual base	*searchName(char*);

	virtual int	save(FILE*);

	virtual int	draw(view*,Matrix44);
};

#endif

