/*
	Fr referenzierbare Objekte gelten folgende Regeln

	1. ref mu in world-reference angelegt sein
	2. jedes Objekt kann ref nur einmal enthalten
	3. aber verschiedene Objekte knnen das selbe ref enthalten
	4. wird ref aus world entfernt, mu ref auch aus allen Objekten entfernt werden

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ref.h"
#include "num.h" 
#include "dim.h"
#include "refptr.h"

ref::ref(base *p,char *n) :
	base(p,n)
{
	numtype = NUM_REF;

	reflist.setErrorValue(NULL);
	objectlist.setErrorValue(NULL);

	if(parent)
		addToParent(parent);
}

ref::~ref()
{
	refptr	*r;
	dim	*d;

	for(r = reflist.getFirst();r != NULL;r = ++reflist)
	{
		//r->removeChild(this);
	}
	reflist.empty();
	for(d = objectlist.getFirst();d != NULL;d = ++objectlist)
	{
		delete d;
	}
	removeFromParent();
}

int	ref::addToParent(base *b)
{
	if(!b) return -2;

	parent = b;
	return b->addChild(this);
}

int	ref::removeFromParent()
{
	if(!parent) return -2;
	return parent->removeChild(this);
}

int	ref::addChild(body *d)
{
	if(!d) return -2;

	return objectlist += d;
}

int	ref::addChild(refptr *r)
{
	if(!r) return -2;

	return reflist += r;
}

int	ref::addChild(csgobj *r)
{
	if(!r) return -2;

	return objectlist += r;
}

int	ref::addChild(blobobj *r)
{
	if(!r) return -2;

	return objectlist += r;
}

int	ref::addChild(nonsolid *r)
{
	if(!r) return -2;

	return objectlist += r;
}

int	ref::removeChild(body *d)
{
	if(!d) return -2;
	if(objectlist.find(d) < 0) return -3;
	return (objectlist.deleteCurrent() ? 0 : -1);
}

int	ref::removeChild(refptr *r)
{
	if(!r) return -2;
	if(reflist.find(r) < 0) return -3;
	return (reflist.deleteCurrent() ? 0 : -1);
}

int	ref::removeChild(csgobj *r)
{
	if(!r) return -2;
	if(objectlist.find(r) < 0) return -3;
	return (objectlist.deleteCurrent() ? 0 : -1);
}

int	ref::removeChild(blobobj *r)
{
	if(!r) return -2;
	if(objectlist.find(r) < 0) return -3;
	return (objectlist.deleteCurrent() ? 0 : -1);
}

int	ref::removeChild(nonsolid *r)
{
	if(!r) return -2;
	if(objectlist.find(r) < 0) return -3;
	return (objectlist.deleteCurrent() ? 0 : -1);
}

void	ref::getChildren(base ***b)
{
	int	t,i;
	base	**bt;

	*b = NULL;
	bt = (base**)malloc(sizeof(void*) * (reflist.length() + objectlist.length() + 1));
	if(!bt) return;

	for(t = 0;t < objectlist.length();t++)
		bt[t] = objectlist[t];
	for(i = 0;i < objectlist.length();i++)
		bt[t + i] = reflist[i];
	bt[t + i] = NULL;
	*b = bt;
}

int	ref::exportPOV(FILE *fp,int tab,int tabsize)
{
	body		*d;
	refptr		*r;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = ref\n");

	printTab(fp,tab);
	fprintf(fp,"{\n");

	for(d = objectlist.getFirst();d != NULL;d = ++objectlist)
	{
		d->exportPOV(fp,tab + tabsize,tabsize);
	}
	for(r = reflist.getFirst();r != NULL;r = ++reflist)
	{
		r->exportPOV(fp,tab + tabsize,tabsize);
	}

	printTab(fp,tab);
	fprintf(fp,"}\n");
	
	return 0;
}

void	ref::dumpNames(int tab,int tabsize)
{
	body		*d;
	refptr		*r;
	int		t;

	for(t = 0;t < tab;t++) printf(" ");

	printf("ref: %s\n",name);

	for(d = objectlist.getFirst();d != NULL;d = ++objectlist)
	{
		d->dumpNames(tab + tabsize,tabsize);
	}
	for(r = reflist.getFirst();r != NULL;r = ++reflist)
	{
		r->dumpNames(tab + tabsize,tabsize);
	}
}

int	ref::existsName(char *n)
{
	body	*d;
	refptr	*r;

	if(n == NULL) return -1;

	if(name != NULL && strcmp(name,n) == 0)
		return !0;

	for(d = objectlist.getFirst();d != NULL;d = ++objectlist)
	{
		if(d->existsName(n)) return !0;
	}
	for(r = reflist.getFirst();r != NULL;r = ++reflist)
	{
		if(r->existsName(n)) return !0;
	}

	return 0;
}

base	*ref::searchName(char *n)
{
	body	*d;
	base	*b;
	refptr	*r;

	if(n == NULL) return NULL;

	if(name != NULL && strcmp(name,n) == 0)
		return this;

	for(d = objectlist.getFirst();d != NULL;d = ++objectlist)
	{
		if((b = d->searchName(n))) return b;
	}
	for(r = reflist.getFirst();r != NULL;r = ++reflist)
	{
		if((b = r->searchName(n))) return b;
	}

	return NULL;
}

int	ref::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);

	writeChunk("REFO");
	SN(name);

	dim	*b;

	for(b = objectlist.getFirst();b != NULL;b = ++objectlist) 
	{ 
		b->save(fp); 
	} 
	
	writeChunkLen();

	return 0;
}

int	ref::draw(view *v,Matrix44 m)
{
	body	*d;
	int	t;

	if(v == NULL) return -1;

	if(isFlag(HIDE)) return 0;

	for(t = 0;t < objectlist.length();t++)
	{
		d = objectlist[t];
		d->draw(v,m);
	}

	return 0;
}






