#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "math.h"
#include "quadric.h"

quadric::quadric(base *p,char *n ):csgobj(p,n)
{
int i,j;
	numtype = NUM_QUADRIC;
	for (i=0;i<3;i++) for (j=0;j<3;j++) {koeff[i][j]=0;}
	k=0;
	if (parent) addToParent(parent);
}

quadric::~quadric()
{
}

int quadric::addToParent(base *p) 
{ 
	if (!p) return -2; 
	return p->addChild(this); 
} 
 
void quadric::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("poly: %s\n", name); 
} 

void quadric::SetKoeff(int x, int y, double k)
{
	koeff[x][y]=k;
}

void quadric::SetOffset(double a)
{
	k=a;
}

int	quadric::exportPOV(FILE *fp,int tab,int tabsize)
{
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = quadric\n");
	printTab(fp,tab);
	fprintf(fp," quadric { <%f, %f, %f>, <%f, %f, %f>, <%f, %f, %f>, %f }\n",koeff[0][0], koeff[1][0], koeff[2][0], koeff[0][1], koeff[1][1], koeff[2][1], koeff[0][2], koeff[1][2], koeff[2][2],k);

	dim::exportPOV(fp,tab,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");

	return 0;
}

int	quadric::save(FILE *fp)
{
	int i,j;

	if (!fp) return -1;	
	setFile(fp);

	writeChunk("QUAD");
	SD(k);
	for (i=0;i<3;i++) { for (j=0;j<3;j++) {SD(koeff[i][j]);}}
	
	dim::save(fp);
	writeChunkLen();
	return 0;
}

int	quadric::load(FILE *fp,int l)
{
	int i,j;

	k=readDouble(fp);
	for (i=0;i<3;i++) { for(j=0;j<3;j++) {koeff[i][j]=readDouble(fp);}}
	dim::load(fp,l);
	return 0;
}

/*
void main()
{
FILE *file;
quadric l;
	file=fopen("test","w+");
	l.SetKoeff(0,0,6.3);
	l.SetKoeff(0,1,7.4);
	l.SetKoeff(0,2,1.2);
	l.SetOffset(3.333);
	l.exportPOV(file,2,2);
	fclose(file);
}
*/
