#ifndef __PRISM__
#define __PRISM__

#include <stdio.h>
#include "csgobj.h"
#include "spline.h"

struct points { double x; double y; };


class prism:public csgobj
{
public:

	SPLINE_TYPE	spline_type;
	SWEEP_TYPE	sweep_type;
	double		height1, height2;
	int		number_of_points;
	list<points>	lpt; 

	prism(base *b=NULL, char *n="Untitled",SPLINE_TYPE=LINEAR, SWEEP_TYPE=CONIC_S, double h1=10, double h2=0);
	~prism();
	void SetHeight1(double h);
	void SetHeight2(double h);
	void AddPoint(double x, double y);
	void RemovePoint(double x, double y, double tol);
	void RemovePoints(double x1, double y1, double x2, double y2);
	
	virtual int addToParent(base *p);
	virtual void dumpNames(int,int);

	virtual int exportPOV(FILE *, int, int);
	virtual int save(FILE *);
	virtual int load(FILE *,int);
	
};

#endif
