#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "math.h"
#include "prism.h"

prism::prism(base *p,char *n, SPLINE_TYPE st, SWEEP_TYPE sw, double h1, double h2 ):csgobj(p,n)
{
struct points p;
	numtype = NUM_PRISM;
	spline_type=st;
	sweep_type=sw;
	number_of_points=0;
	height1=h1;
	height2=h2;
	p.x=-1;p.y=-1;
	lpt.setErrorValue(p);
}

prism::~prism()
{
}

int prism::addToParent(base *p)
{
	if (!p) return -2;
	return p->addChild(this);
}

void prism::dumpNames(int tab,int)
{
	printTab(stderr,tab);
	printf("sphere: %s\n", name);
}

void prism::SetHeight1(double h)
{
	height1=h;
}

void prism::SetHeight2(double h)
{
	height2=h;
}

void prism::AddPoint(double x, double y)
{
struct points p1,p2,p;
int ende=0;

	p.x=x;p.y=y;
	p1=lpt.getFirst();
	p2=++lpt;
	while (ende==0) {
		if ((p1.y<y)&&(p2.y>y)) {
			printf("Inserting\n");
			lpt.insert(p);
			number_of_points++;
			return ;
		}
		p1=p2;
		p2=++lpt;
		if ((p2.x==-1)&&(p2.y==-1)) { ende=1;}
	}
	lpt+=p;
	number_of_points++;
}

void prism::RemovePoint(double x, double y, double toleranz)
{
struct points p;
int ende=0;
	p=lpt.getFirst();
	while (ende==0) { 
		if (( fabs(p.x-x)<toleranz)&&(fabs(p.y-y)<toleranz)) { 
			lpt.deleteCurrent();
			number_of_points--;
			return ;
		}
		p=++lpt;
		if ((p.x==-1)&&(p.y==-1)) { ende=1;}
	}
	
}

void prism::RemovePoints(double x1,double y1, double x2, double y2)
{
struct points p;
	
	p=lpt.getFirst();
	while ((p.x!=-1)&&(p.y!=-1)) {
		if ((p.x>x1)&&(p.x<x2)&&(p.y>y1)&&(p.y<y2)) {
			lpt.deleteCurrent();
			number_of_points--;
		}
		p=++lpt;
	}
	printf("deleted\n");
}

int	prism::exportPOV(FILE *fp,int tab,int tabsize)
{
struct points p=lpt.getFirst();
long l=lpt.length();
int i;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = prism\n");
	printTab(fp,tab);
	fprintf(fp,"prism { \n");
	printTab(fp,tab);
	switch (sweep_type) {
		case LINEAR_S:
			fprintf(fp,"linear_sweep\n");
			break;
		case CONIC_S:
			fprintf(fp,"conic_sweep\n");
			break;
	}
	printTab(fp,tab);
	switch (spline_type) {
		case LINEAR:
			fprintf(fp,"linear_spline\n");
		break;
		case CUBIC:
			fprintf(fp,"cubic_spline\n");	
		break;
		case QUADRATIC:
			fprintf(fp,"quadratic_spline\n");
		break;
	}
	printTab(fp,tab);
	fprintf(fp,"%f,\n",height1);
	fprintf(fp,"%f,\n",height2);
	p=lpt.getFirst();
	fprintf(fp,"%i, \n",number_of_points);
	for (i=0;i<l-1;i++) {
		printTab(fp,tab);
		fprintf(fp,"< %f, %f>, \n",p.x,p.y);
		p=++lpt;
	}
	printTab(fp,tab);
	fprintf(fp,"< %f, %f> \n",p.x,p.y);
	

	dim::exportPOV(fp,tab,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");

	return 0;
}

int prism::save(FILE *fp)
{
struct points p=lpt.getFirst();
long l=lpt.length(),i;


	if (fp) return -1;
	setFile(fp);
	writeChunk("PRIS");
	SN(name);
	SI(spline_type);
	SI(sweep_type);
	SD(height1);
	SD(height2);
	SI(number_of_points);
	for (i=0;i<l;i++) {
		SD(p.x);SD(p.y);
		p=++lpt;
	}	
	dim::save(fp);
	writeChunkLen();
	return 0;
}

int prism::load(FILE *fp, int ll)
{
int i,l;
	spline_type=(SPLINE_TYPE)readInt(fp);
	sweep_type=(SWEEP_TYPE)readInt(fp);
	height1=readDouble(fp);
	height2=readDouble(fp);
	l=readInt(fp);
	for (i=0;i<l;i++) {AddPoint(readDouble(fp),readDouble(fp)); }
	dim::load(fp,ll);
	return 0;
}

/*
void main()
{
FILE *file;
lathe l;
	file=fopen("test","w+");
	l.AddPoint(1,1);
	l.AddPoint(3,3);
	l.AddPoint(2,2);
	l.exportPOV(file,2,2);
	fclose(file);
}*/
