#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "math.h"
#include "poly.h"

poly::poly(base *p,char *n, int ord ):csgobj(p,n)
{
int i;
	numtype = NUM_POLY;
	order=ord;
	count=0;
	MaxKoeff=(int)(((ord+1)*(ord+2)*(ord+3))/6);
	for (i=0;i<134;i++) { koeff[i]=0; }
	if (parent) addToParent(parent);
}

poly::~poly()
{
}

int poly::addToParent(base *p) 
{ 
	if (!p) return -2; 
	return p->addChild(this); 
} 
 
void poly::dumpNames(int tab, int tabsize) 
{ 
	printTab(stderr,tab); 
	printf("poly: %s\n", name); 
} 
 

void poly::AddKoeff(double k)
{
	if (count==MaxKoeff) { return;}
	koeff[count++]=k;
}

void poly::Reset()
{
int i;
	count=0;
	for (i=0;i<134;i++) { koeff[i]=0; }
}

void poly::NewOrder(int ord)
{
	MaxKoeff=(int)(((ord+1)*(ord+2)*(ord+3))/6);
	order=ord;
	count=0;
}

int	poly::exportPOV(FILE *fp,int tab,int tabsize)
{
int i;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = poly\n");
	printTab(fp,tab);
	fprintf(fp,"poly { %d, < ",order);
	for (i=0;i<count-1;i++) {
		fprintf(fp," %f, ",koeff[i]);
	}
	fprintf(fp,"%f > \n",koeff[count]);

	dim::exportPOV(fp,tab,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");

	return 0;
}

int poly::save(FILE *fp)
{
int i;
	if (!fp) return -1;
	setFile(fp);
	writeChunk("POL ");
	SN(name);
	SI(order);
	for (i=0;i<134;i++) { SD(koeff[i]); }	
	dim::save(fp);
	writeChunkLen();
	return 0;
}

int poly::load(FILE *fp,int l)
{
int i;
	order=readInt(fp);
	for (i=0;i<134;i++) { koeff[i]=readDouble(fp);}	

	dim::load(fp,l);
	return 0;
}

/*
void main()
{
FILE *file;
poly l;
	file=fopen("test","w+");
	l.AddKoeff(1);
	l.AddKoeff(2);
	l.AddKoeff(3);
	l.exportPOV(file,2,2);
	fclose(file);
}*/
