#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plane.h"
#include "num.h"

plane::plane(base *p,char *n) :
	csgobj(p,n)
{
	numtype = NUM_PLANE;

	if(parent) addToParent(parent);
}

plane::~plane()
{
	removeFromParent();
}

void	plane::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("plane: %s\n",name);
}

int 	plane::addToParent(base *p)
{
	if (!p) return -2;

	parent = p;
	return p->addChild(this);
}

int 	plane::removeFromParent()
{
	if (!parent) return -2;
	return parent->removeChild(this);
}
 
int	plane::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = plane\n");
	printTab(fp,tab);
	fprintf(fp,"plane\n");
	printTab(fp,tab); 
	fprintf(fp,"{\n"); 
	printTab(fp,tab + tabsize); 
	fprintf(fp,"< 0, 1, 0>, 0\n"); 
	
	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	plane::save(FILE *fp)
{
	setFile(fp);
	writeChunk("PLNE");
	SN(name);
	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	plane::load(FILE *fp,int l)
{
	dim::load(fp,l);

	return 0;
}

int	plane::draw(view *v,Matrix44 m)
{
	Vector3	p,vx,vy,vz;

	//printf("Plane\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(1,0,0);
	vy = Vector3(0,1,0);
	vz = Vector3(0,0,1);

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawLine(vx + vz * 1.1,vx - vz * 1.1,m);
	v->drawLine(vx * 1.1 - vz,-vx * 1.1 - vz,m);
	v->drawLine(-vx - vz * 1.1,-vx + vz * 1.1,m);
	v->drawLine(-vx * 1.1 + vz,vx * 1.1 + vz,m);
	v->drawLine(p,vy * 1,m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}


