#ifndef obj_inc
#define obj_inc

#include <stdio.h>
#include "num.h"
#include "list.h"
#include "body.h"
#include "refptr.h"
#include "csgobj.h"
#include "blob.h"
#include "nonsolid.h"

class obj : public body
{
protected:
	list<body*>	children;

public:
	obj(base *p=NULL, char *n="Untitled");
	~obj();

	void		dumpNames(int tabsize = 2);
	void		dumpNames(int,int);

	virtual int	save(FILE*);
	virtual int	load(FILE*,int);

	int		exportPOV(FILE*,int tab,int tabsize);

	virtual int	addToParent(base*);
	virtual int	removeFromParent();

	virtual int	addChild(body*);
	virtual int	addChild(refptr*);
	virtual int	addChild(csgobj*);
	virtual int	addChild(blob*);
	virtual int	addChild(blobobj*);
	virtual int	addChild(nonsolid*);

	virtual int	removeChild(body *);
	virtual int	removeChild(refptr*);
	virtual int	removeChild(csgobj*);
	virtual int	removeChild(blob*);
	virtual int	removeChild(blobobj*);
	virtual int	removeChild(nonsolid*);

	virtual void	getChildren(base ***b)
	{
		int	t;
		base	**bt;

		*b = NULL;
		bt = (base**)malloc(sizeof(void*) * (children.length() + 1));
		if(!bt) return;

		for(t = 0;t < children.length();t++)
			bt[t] = children[t];
		bt[t] = NULL;
		*b = bt;
	}

	virtual int	hasChild(body *);

	virtual base	*searchName(char *n);
	virtual int	existsName(char *n);

	virtual int	draw(view*,Matrix44);
};

#endif	
