#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "obj.h"
#include "view.h"

obj::obj(base *p, char *n):
	body(p,n)
{
	numtype = NUM_OBJ;

	children.setErrorValue(NULL);

	if(parent) addToParent(parent);
}

obj::~obj()
{
	body	*b;

	while((b = children.getFirst()))
	{
		delete b;
		children.deleteCurrent();
		while(children.find(b) >= 0)
			children.deleteCurrent();
	}
	removeFromParent();
}


void	obj::dumpNames(int tab,int tabsize)
{
	body		*d;
	int		t;

	for(t = 0;t < tab;t++) printf(" ");

	printf("obj: %s\n",name);

	for(d = children.getFirst();d != NULL;d = ++children)
	{
		d->dumpNames(tab + tabsize,tabsize);
		children.find(d);	// Laufzeiteffekte abfangen
	}
}

void	obj::dumpNames(int tabsize)
{
	dumpNames(0,tabsize);
}

int	obj::exportPOV(FILE *fp,int tab,int tabsize)
{
	body	*b;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = obj\n");

	printTab(fp,tab);
	fprintf(fp,"{\n");

	for(b = children.getFirst();b != NULL;b = ++children)
	{
		b->exportPOV(fp,tab + tabsize,tabsize);
		children.find(b);	// Laufzeiteffekte abfangen
	}

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	obj::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	obj::removeFromParent()
{
	if(!parent) return -2;

	return parent->removeChild(this);
}

int	obj::addChild(body* child)
{
	if(!child) return -2;
	//if(hasChild(child)) return -3;
	return children += child;
}

int	obj::addChild(refptr* child)
{
	if(!child) return -2;
	//if(hasChild(child)) return -3;
	return children += child;
}

int	obj::addChild(csgobj* child)
{
	if(!child) return -2;
	//if(hasChild(child)) return -3;
	return children += child;
}

int	obj::addChild(blobobj* child)
{
	if(!child) return -2;
	//if(hasChild(child)) return -3;
	return children += child;
}

int	obj::addChild(blob* child)
{
	if(!child) return -2;
	//if(hasChild(child)) return -3;
	return children += child;
}

int	obj::addChild(nonsolid* child)
{
	if(!child) return -2;
	//if(hasChild(child)) return -3;
	return children += child;
}

/*
int	obj::moveChild(dim *b) 
{ 
	if(!b->getParent()) return -1; 
 
	b->getParent()->removeChild(b);
	addChild(b);

	return 0; 
} 
*/

int	obj::removeChild(body *b) 
{ 
	if(!hasChild(b)) return -1; 

	if(children.find(b) < 0) return -2;
	children.deleteCurrent();

	return 0; 
} 

int	obj::removeChild(refptr *b) 
{ 
	if(!hasChild(b)) return -1; 

	if(children.find(b) < 0) return -2;
	children.deleteCurrent();

	return 0; 
} 

int	obj::removeChild(csgobj *b) 
{ 
	if(!hasChild(b)) return -1; 

	if(children.find(b) < 0) return -2;
	children.deleteCurrent();

	return 0; 
} 

int	obj::removeChild(blob *b) 
{ 
	if(!hasChild(b)) return -1; 

	if(children.find(b) < 0) return -2;
	children.deleteCurrent();

	return 0; 
} 

int	obj::removeChild(blobobj *b) 
{ 
	if(!hasChild(b)) return -1; 

	if(children.find(b) < 0) return -2;
	children.deleteCurrent();

	return 0; 
} 

int	obj::removeChild(nonsolid *b) 
{ 
	if(!hasChild(b)) return -1; 

	if(children.find(b) < 0) return -2;
	children.deleteCurrent();

	return 0; 
} 

int	obj::hasChild(body *c)
{
	body	*b;

	for(b = children.getFirst();b != NULL;b = ++children)
	{
		if(b == c) return !0;
		if(b->hasChild(c)) return !0;
	}

	return 0;
}

int	obj::existsName(char *n)
{
	body	*d;

	if(n == NULL) return -1;

	if(name != NULL && strcmp(name,n) == 0)
		return !0;

	for(d = children.getFirst();d != NULL;d = ++children)
	{
		if(d->existsName(n)) return !0;
		children.find(d);	// Laufzeiteffekte abfangen
	}

	return 0;
}

base	*obj::searchName(char *n)
{
	body	*d;
	base	*b;

	if(n == NULL) return NULL;

	if(name != NULL && strcmp(name,n) == 0)
		return this;

	for(d = children.getFirst();d != NULL;d = ++children)
	{
		if((b = d->searchName(n))) return b;
		children.find(d);	// Laufzeiteffekte abfangen
	}

	return NULL;
}

int	obj::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);

	writeChunk("OBJC");
	SN(name);

	body	*b;

	for(b = children.getFirst();b != NULL;b = ++children) 
	{ 
		b->save(fp); 
		children.find(b);	// Laufzeiteffekte abfangen
	} 
	
	dim::save(fp);

	writeChunkLen();

	return 0;
}

int	obj::load(FILE *fp,int l)
{
	int	pos = ftell(fp);
	base	*b;

	while(ftell(fp) < pos + l - (int)sizeof(double) * 12)
	{
		b = parse(fp);
		if(b)
		{
			b->addToParent(this);
			b->setParent(this);
		}
	}

	dim::load(fp,l - (ftell(fp) - pos));

	return 0;
}

int	obj::draw(view *v,Matrix44 m)
{
	body		*d;
	int		t;
	Vector3		vec(0,0,0);

	if(v == NULL) return -1;

	if(isFlag(HIDE)) return 0;

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawCross(vec,m);

	for(t = 0;t < children.length();t++)
	{
		d = children[t];
		d->draw(v,m);
	}

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}


