
#ifndef mesh_inc
#define mesh_inc

#include <stdio.h>
#include "list.h"
#include "nonsolid.h"

struct tri { 	double x1; double y1; double z1;
		double x2; double y2; double z2;
		double x3; double y3; double z3; 
		int smooth;
		double nx1; double ny1; double nz1;
		double nx2; double ny2; double nz2;
		double nx3; double ny3; double nz3;

		
};
		

class mesh:public nonsolid
{
public:
	list<tri> tlist;

	mesh(base *p=NULL, char *n="Untitled");
	~mesh();

	void AddTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
	void AddTriangle(Vector3 v1, Vector3 v2, Vector3 v3);
	void RemoveTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
	void RemoveTriangle(Vector3 v1, Vector3 v2, Vector3 v3);

	void SetNormal(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
	void SetNormal(Vector3 v1, Vector3 v2, Vector3 v3);
	void SetSmooth(int s);

	virtual int addToParent(base *);
	virtual int removeFromParent();
	virtual void dumpNames(int,int);

	virtual int exportPOV(FILE *,int,int);
	virtual int save(FILE *);
	virtual int load(FILE *,int);

	virtual int	draw(view *,Matrix44)
	{
		return -3;
	}
};
#endif
