#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "mesh.h"

mesh::mesh(base *p,char *n ):nonsolid(p,n)
{
	tri t;

	t.x1=-123;t.y1=456;t.z1=0.789;
	numtype = NUM_MESH;
	tlist.setErrorValue(t);
	if (parent) addToParent(parent);
}

mesh::~mesh()
{
	removeFromParent();
}

int	mesh::addToParent(base *p)
{
	if (!p) return(-2);

	parent = p;
	return p->addChild(this);
}

int	mesh::removeFromParent() 
{ 
	if (!parent) return(-2); 
	return parent->removeChild(this); 
}

void mesh::dumpNames(int tab, int)
{
	printTab(stderr, tab);
	printf("mesh: %s\n",name);
}

void mesh::AddTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
tri t;
	t.x1=x1;t.y1=y1;t.z1=z1;
	t.x2=x2;t.y2=y2;t.z2=z2;
	t.x3=x3;t.y3=y3;t.z3=z3;	
	tlist+=t;
}

void mesh::SetNormal(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
tri t=tlist.getCurrent();
	tlist.deleteCurrent();
	t.nx1=x1;t.ny1=y1;t.nz1=z1;
	t.nx2=x2;t.ny2=y2;t.nz2=z2;
	t.nx3=x3;t.ny3=y3;t.nz3=z3;
	t.smooth=1;
	tlist.insert(t);
	
}

void mesh::SetNormal(Vector3 v1, Vector3 v2, Vector3 v3)
{
tri t=tlist.getCurrent();
	tlist.deleteCurrent();	
	t.nx1=v1[0];t.y1=v1[1];t.z1=v1[2];
	t.nx2=v2[0];t.y2=v2[1];t.z2=v2[2];
	t.nx3=v3[0];t.y3=v3[1];t.z3=v3[2];
	t.smooth=1;
	tlist.insert(t);
}

void mesh::SetSmooth(int)
{
	tri t=tlist.getCurrent();

	tlist.deleteCurrent();
	t.smooth=1;
	tlist.insert(t);
}


void mesh::AddTriangle(Vector3 v1, Vector3 v2, Vector3 v3)
{
tri t;
	t.x1=v1[0];t.y1=v1[1];t.z1=v1[2];
	t.x2=v2[0];t.y1=v2[1];t.z2=v2[2];
	t.x3=v3[0];t.y1=v3[1];t.z3=v3[2];
	tlist+=t;
}

void mesh::RemoveTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
Vector3 v1,v2,v3;
	v1 = Vector3(x1,y1,z1);
	v2 = Vector3(x2,y2,z2);
	v3 = Vector3(x3,y3,z3);
	RemoveTriangle(v1,v2,v3);
}

void mesh::RemoveTriangle(Vector3 v1, Vector3 v2, Vector3 v3)
{
tri t;
int ende=0;

	t=tlist.getFirst();
	while (ende==0) {
		if ((t.x1==v1[0])&&(t.y1==v1[1])&&(t.z1==v1[2])&&(t.x2=v2[0])&&(t.y2==v2[1])&&(t.z2==v2[2])&&(t.x3==v3[0])&&(t.y3==v3[1])&&(t.z3==v3[2])) {
			tlist.deleteCurrent();
			return;
		}
		t=++tlist;
		if ((t.x1==-123)&&(t.y1==456)&&(t.z1==0.789)) { return;}
	}
}

int	mesh::exportPOV(FILE *fp,int tab,int tabsize)
{
struct tri t=tlist.getFirst();
long l=tlist.length();
int i;

	if (l>0) {
		printTab(fp,tab);
		fprintf(fp,"// Objectname = %s\n",name);
		printTab(fp,tab);
		fprintf(fp,"// Objecttype = mesh\n");
		printTab(fp,tab);
		fprintf(fp,"mesh { \n");
		for (i=0;i<l;i++) {
			printTab(fp,tab);
			t=tlist.getFirst();
			if (t.smooth==0) { fprintf(fp,"triangle {\n"); } else { fprintf(fp,"smooth_triangle {\n"); }
			printTab(fp,tab+tabsize);
			if (t.smooth==0) {
				fprintf(fp,"<%f, %f, %f>, <%f, %f, %f>, <%f, %f, %f> ",t.x1,t.y1,t.z1,t.x2,t.y2,t.z2,t.x3,t.y3,t.z3);
			} else {
				fprintf(fp,"<%f, %f, %f>, <%f, %f, %f>\n",t.x1,t.y1,t.z1,t.nx1,t.ny1,t.nz1);
				printTab(fp,tab+tabsize);
				fprintf(fp,"<%f, %f, %f>, <%f, %f, %f>\n",t.x2,t.y2,t.z2,t.nx2,t.ny2,t.nz2);
				printTab(fp,tab+tabsize);
				fprintf(fp,"<%f, %f, %f>, <%f, %f, %f>\n",t.x3,t.y3,t.z3,t.nx3,t.ny3,t.nz3);

			}
			printTab(fp,tab);
			dim::exportPOV(fp, tab, tabsize);
			fprintf(fp,"} \n");
			t=++tlist;
		}
		// dim::exportPOV(fp,tab,tabsize);

		printTab(fp,tab);
		fprintf(fp,"}\n\n");
	}

	return 0;
}

int	mesh::save(FILE *fp)
{
struct tri t=tlist.getFirst();
int l=tlist.length();
int i;

	if (!fp) return -1;
	setFile(fp);
	writeChunk("MESH");
	SN(name);
	SI(l);
	for (i=0;i<l;i++) {
		SI(t.smooth);
		SD(t.x1);SD(t.y1);SD(t.z1);
		if (t.smooth==1) { SD(t.nx1);SD(t.ny1);SD(t.nz1); }
		SD(t.x2);SD(t.y2);SD(t.z2);
		if (t.smooth==1) { SD(t.nx2);SD(t.ny2);SD(t.nz2); }
		SD(t.x3);SD(t.y3);SD(t.z3);
		if (t.smooth==1) { SD(t.nx3);SD(t.ny3);SD(t.nz3); }
		t=++tlist;
	}		
	dim::save(fp);
	writeChunkLen();
	return 0;
}

int	mesh::load(FILE *fp,int ll)
{
tri t;
int l,i;
	l=readInt(fp);
	for (i=0;i<l;i++) {
		t.smooth=readInt(fp);
		t.x1=readDouble(fp);
		t.y1=readDouble(fp);
		t.z1=readDouble(fp);
		t.x2=readDouble(fp);
		t.y2=readDouble(fp);
		t.z2=readDouble(fp);
		t.x3=readDouble(fp);
		t.y3=readDouble(fp);
		t.z3=readDouble(fp);
		if (t.smooth==1) {
			t.nx1=readDouble(fp);
			t.ny1=readDouble(fp);
			t.nz1=readDouble(fp);
			t.nx2=readDouble(fp);
			t.ny2=readDouble(fp);
			t.nz2=readDouble(fp);
			t.nx3=readDouble(fp);
			t.ny3=readDouble(fp);
			t.nz3=readDouble(fp);
		}
		tlist+=t;
	};	
	dim::load(fp,ll);
	return 0;
}

/*
void main()
{
FILE *file;
mesh m;
	file=fopen("test","w+");
	m.AddTriangle(1,1,1,2,2,2,3,3,3);

	m.AddTriangle(1,1,1,2,2,2,3,3,3);

	m.AddTriangle(1,1,1,2,2,2,3,3,3);

	m.AddTriangle(1,1,1,2,2,2,3,3,3);

	m.AddTriangle(1,1,1,2,2,2,3,3,3);
	m.exportPOV(file,2,2);
	fclose(file);
}

*/
