#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "lightpoint.h"
#include "num.h"
#include "view.h" 

lightpoint::lightpoint(base *p,char *n) :
	lightobj(p,n)
{
	numtype = NUM_LIGHTPOINT;
	r=1;g=1;b=1;
	fade_distance=0;
	fade_power=0;
	atmos_attenuation=0;
	
	if(parent) addToParent(parent);
}

lightpoint::~lightpoint()
{
	removeFromParent();
}

void lightpoint::SetColor(double c1, double c2, double c3)
{
	r=c1;g=c2;b=c3;
}

void lightpoint::SetFadeDistance(double d)
{
	fade_distance=d;
}

void lightpoint::SetFadePower(double p)
{
	fade_power=p;
}

void	lightpoint::SetAtmosAtt(int a)
{
	atmos_attenuation=a;
}

int	lightpoint::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int 	lightpoint::removeFromParent()
{
	if (!parent) return -2;
	return parent->removeChild(this);
}
 
int     lightpoint::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = lightpoint\n");

	printTab(fp,tab);
	fprintf(fp,"light_source\n");
	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	fprintf(fp,"<0, 0, 0>\n");
	printTab(fp,tab + tabsize); 
	fprintf(fp,"color rgb<%f, %f, %f> \n",r,g,b); 
	printTab(fp,tab+tabsize);
	fprintf(fp,"fade_distance %f \n",fade_distance);
	printTab(fp, tab+tabsize);
	fprintf(fp,"fade_power %f \n",fade_power);
	printTab(fp, tab+tabsize);
	if (atmos_attenuation==1) {fprintf(fp,"atmospheric_attenuation TRUE\n");}
	
	dim::exportPOV(fp,tab + tabsize,tabsize);
	
	printTab(fp,tab); 
	fprintf(fp,"}\n\n");

	return 0;
}

void	lightpoint::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("lightpoint: %s\n",name); 
}


int	lightpoint::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);
	writeChunk("LPNT");
	SN(name);

	SD(r);SD(g);SD(b);
	SD(fade_distance);
	SD(fade_power);
	SI(atmos_attenuation);

	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	lightpoint::load(FILE *fp,int l)
{
	r=readDouble(fp);
	g=readDouble(fp);
	b=readDouble(fp);
	fade_distance=readDouble(fp);
	fade_power=readDouble(fp);
	atmos_attenuation=readInt(fp);	

	dim::load(fp,l);
	return 0;
}

int	lightpoint::draw(view *v,Matrix44 m)
{
	Vector3	p(0,0,0);

	if(isFlag(HIDE)) return 0;

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawCross(p,m);
	v->drawSymbol(p,"lightpoint",m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}



