
#ifndef lathe_inc
#define lathe_inc

#include <stdio.h>
#include "csgobj.h"
#include "spline.h"


class lathe : public csgobj
{
	class points
	{
	public:
		double x;
		double y;

	public:
		points() {x = 0;y = 0;};
		points(double a,double b) {x = a;y = b;};
	};

public:

	SPLINE_TYPE spline_type;
	long number_of_points;
	list<points> lpt; 
	lathe(base *b=NULL, char *n="Untitled",SPLINE_TYPE=LINEAR);
	~lathe();

	void AddPoint(double x, double y);
	void RemovePoint(double x, double y, double tol);
	void RemovePoints(double x1, double y1, double x2, double y2);

	virtual int addToParent(base *);
	virtual void dumpNames(int, int);	

	virtual int exportPOV(FILE *, int, int);
	virtual int load(FILE *, int);
	virtual int save(FILE *);
};

#endif
