#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "heightfield.h"
#include "num.h"

heightfield::heightfield(base *p,char *n, char *fn, bool  h, bool s, float wl) :csgobj(p,n)
{
	numtype = NUM_HEIGHTFIELD;
	filename=strdup(fn);
	hierarchy=h;
	smooth=s;
	water_level=wl;
	if (parent) addToParent(parent);
}

heightfield::~heightfield()
{
	if (filename) {free(filename); }
	removeFromParent();
}

int heightfield::addToParent(base *p)
{
	if (!p) return -2;
	parent = p;
	return p->addChild(this);
}

int heightfield::removeFromParent() 
{ 
	if (!parent) return -2; 
	return parent->removeChild(this); 
} 
 
void heightfield::dumpNames(int tab,int)
{
	printTab(stderr, tab);
	printf("heightfield: %s\n",name);
}

int	heightfield::exportPOV(FILE *fp,int tab,int tabsize)
{
	char *filetype;
	
	filetype=strrchr(filename,(int)".");
	if (filetype==NULL) { filetype="sys"; }

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = heightfield\n");
	printTab(fp,tab);
	fprintf(fp,"heightfield {%s \"%s\" \n",filetype,filename);
	printTab(fp,tab);

	if (hierarchy==FALSE) {fprintf(fp,"hierarchy FALSE \n");}
	else { fprintf(fp,"hierarchy TRUE \n"); }

	printTab(fp,tab);
	if (smooth==FALSE) {fprintf(fp,"smooth FALSE \n");}
	else {fprintf(fp,"smooth TRUE \n"); }
	printTab(fp,tab);
	fprintf(fp,"water_level %f \n",water_level);

	dim::exportPOV(fp,tab,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");

	return 0;
}

int heightfield::save(FILE *fp)
{
	if (!fp) return -1;
	setFile(fp);
	
	writeChunk("HFLD");
	SN(name);
	SI(hierarchy);
	SI(smooth);
	SD(water_level);
	dim::save(fp);
	writeChunkLen();
	return(0);
}

int heightfield::load(FILE *fp,int l)
{
	hierarchy=readInt(fp);
	smooth=readInt(fp);
	water_level=readDouble(fp);
	dim::load(fp,l - 16);
	
	return 0;
}

