#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "disc.h"

disc::disc(base *p,char *n,double xn, double yn, double zn, double r, double hr ):nonsolid(p,n)
{
	numtype = NUM_DISC;
	normal = Vector3(xn,yn,zn);
	radius=r;
	hole_radius=hr;
	if (parent) addToParent(parent);
}

disc::~disc()
{
}

int disc::addToParent(base *p)
{
	if (!p) return -2;
	return p->addChild(this);
}

void disc::dumpNames(int tab, int)
{
	printTab(stderr, tab);
	printf("disc: %s\n",name);
}

int	disc::exportPOV(FILE *fp,int tab,int tabsize)
{
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = disc\n");

	printTab(fp,tab);
	fprintf(fp,"disc\n");
	printTab(fp,tab+tabsize);
	fprintf(fp,"{<0, 0, 0>,<%f, %f, %f>,\n", normal(0), normal(1), normal(2));
	printTab(fp,tab+tabsize);
	fprintf(fp,"%f, %f\n",radius, hole_radius);

	exportPOV(fp,tab,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");	

	return 0;
}

int disc::save(FILE *fp)
{
	if (!fp) return -1;
	setFile(fp);

	writeChunk("DISC");
	SN(name);
	SV(normal);
	SD(radius);
	SD(hole_radius);
	dim::save(fp);
	writeChunkLen();
	return 0;
}

int disc::load(FILE *fp,int l)
{
	normal = Vector3(readDouble(fp),readDouble(fp),readDouble(fp));
	radius=readDouble(fp);
	hole_radius=readDouble(fp);
	dim::load(fp,l);
	return 0;
}
