#ifndef dim_inc
#define dim_inc

#define DIMSAVE()	{SV(vscale);SV(vrotate);SV(vtranslate);}

#include <stdio.h>
#include "num.h"
#include "list.h"
#include "base.h"

class dim : public base
{
protected:
	Vector3		vscale,vrotate,vtranslate;

public:
	dim(base *p = NULL,char *n="Untitled");
	~dim();

	void		translate(Vector3 v);
	void		rotate(Vector3 v);
	void		scale(Vector3 v);
	void		scale(double d);

	Vector3		&getVScale()
	{
		return vscale;
	}
	Vector3		&getVRotate()
	{
		return vrotate;
	}
	Vector3		&getVTranslate()
	{
		return vtranslate;
	}
	void		dimMatrix(Matrix44 &m)
	{
		Matrix44	h,h2;

		h2.unify();
		h.scaleVector(vscale);
		h2 *= h;
		h.rotateVector(vrotate);
		h2 *= h;
		h.transposeVector(vtranslate);
		h2 *= h;
		m *= h2;
	}

	virtual int	addToParent(base*) = 0;
	virtual int	removeFromParent() = 0;

	virtual int	exportPOV(FILE*,int tab,int tabsize);

	virtual void	dumpNames(int tab,int tabsize) = 0;

	virtual int	save(FILE*);
	virtual int	load(FILE*,int);

	//virtual int	paint();
};

#endif	
