#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "dim.h"

dim::dim(base *p,char *n) :
	base(p,n)
{
	numtype = NUM_DIM;
	vscale = Vector3(1,1,1);
	vrotate = Vector3(0,0,0);
	vtranslate = Vector3(0,0,0);
}

dim::~dim()
{
}

int	dim::exportPOV(FILE *fp,int tab,int)
{
	printTab(fp,tab);
	fprintf(fp,"scale     <%g,%g,%g>\n",vscale(0),vscale(1),vscale(2));
	printTab(fp,tab);
	fprintf(fp,"rotate    <%g,%g,%g>\n",vrotate(0) * 180 / PI,vrotate(1) * 180 / PI,vrotate(2) * 180 / PI);
	printTab(fp,tab);
	fprintf(fp,"translate <%g,%g,%g>\n",vtranslate(0),vtranslate(1),vtranslate(2));

	return 0;
}

void	dim::translate(Vector3 v)
{
	vtranslate += v;
}

void	dim::rotate(Vector3 v)
{
	vrotate += v;
}

void	dim::scale(Vector3 v)
{
	vscale(0) *= v(0);
	vscale(1) *= v(1);
	vscale(2) *= v(2);
}

void	dim::scale(double d)
{
	vscale *= d;
}

int	dim::save(FILE *fp)
{
	chunk	c;

	if(!fp) return -1;

	c.setFile(fp);
	c.writeChunk("DIM ");
	SV(vscale);
	SV(vrotate);
	SV(vtranslate);
	c.writeChunkLen();

	return 0;
}



int	dim::load(FILE *fp,int)
{
	char	chunk[4];
	int	len;
	double	x,y,z;

	fread(chunk,1,4,fp);
	fread(&len,1,4,fp);

	if(strncmp(chunk,"DIM ",4) != 0)
	{
		fseek(fp,-8,SEEK_CUR);
		return -1;
	}

	fread(&x,1,sizeof(double),fp);
	fread(&y,1,sizeof(double),fp);
	fread(&z,1,sizeof(double),fp);
	vscale = Vector3(x,y,z);	
	fread(&x,1,sizeof(double),fp);
	fread(&y,1,sizeof(double),fp);
	fread(&z,1,sizeof(double),fp);
	vrotate = Vector3(x,y,z);	
	fread(&x,1,sizeof(double),fp);
	fread(&y,1,sizeof(double),fp);
	fread(&z,1,sizeof(double),fp);
	vtranslate = Vector3(x,y,z);	

	return 0;
}
