#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cylinder.h"
#include "num.h"

cylinder::cylinder(base *p,char *n,double st) :
	blobobj(p,n,st)
{
	numtype = NUM_CYLINDER;

	if(parent) addToParent(parent);
}

cylinder::~cylinder()
{
	removeFromParent();
}

int	cylinder::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	cylinder::removeFromParent() 
{ 
	if(!parent) return -2; 

	return parent->removeChild(this); 
} 
 
void	cylinder::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("cylinder: %s\n",name);
}

int	cylinder::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = cylinder\n");

	printTab(fp,tab);
	fprintf(fp,"cylinder\n");
	printTab(fp,tab); 
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize); 
	fprintf(fp,"<0,0,0.5>, <0,0,-0.5>, 0.5"); 

	if (!isBlobObject())
		fprintf(fp,"\n");
	else
		fprintf(fp,"%f\n",strength);

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	cylinder::save(FILE *fp)
{
	setFile(fp);
	writeChunk("CYLD");
	SN(name);
	SD(strength);
	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	cylinder::load(FILE *fp,int l)
{
	fread(&strength,1,sizeof(double),fp);

	dim::load(fp,l - sizeof(double));

	return 0;
}

int	cylinder::draw(view *v,Matrix44 m)
{
	Vector3	p,vx,vy,vz;

	//printf("Cylinder\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(0.5,0,0);
	vy = Vector3(0,0.5,0);
	vz = Vector3(0,0,0.5);

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawCylinder(p,vx,vy,vz,m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}


