#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "math.h"
#include "cubic.h"

cubic::cubic(base *p,char *n ):csgobj(p,n)
{
int i;
	numtype = NUM_CUBIC;
	count=0;
	for (i=0;i<19;i++) {koeff[i]=0;}
	if (parent) addToParent(parent);
}

cubic::~cubic()
{
}

int cubic::addToParent(base *p) 
{ 
	if (!p) return -2; 
	return p->addChild(this); 
} 
 
void cubic::dumpNames(int tab, int tabsize) 
{ 
	printTab(stderr,tab); 
	printf("cubic: %s\n", name); 
} 

cubic::AddKoeff(double k)
{
	if (count==19) { return 0;}
	koeff[count++]=k;
}

cubic::Reset()
{
int i;
	for (i=0;i<19;i++) {koeff[i]=0;}
	count=0;
}

int	cubic::exportPOV(FILE *fp,int tab,int tabsize)
{
int i;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = cubic\n");
	printTab(fp,tab);
	fprintf(fp,"cubic { < ");
	for (i=0;i<19;i++) {
		fprintf(fp," %f, ",koeff[i]);
	}
	fprintf(fp,"%f > \n",koeff[count]);

	dim::exportPOV(fp,tab,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");

	return 0;
}

cubic::save(FILE *fp)
{
int i;
	if (!fp) return -1;
	setFile(fp);
	writeChunk("CUBI");
	SN(name);
	for (i=0;i<19;i++) { SD(koeff[i]); }
	dim::save(fp);
	writeChunkLen();
	return 0;
}

cubic::load(FILE *fp,int l)
{
int i;

	for (i=0;i<19;i++) { koeff[i]=readDouble(fp);}
	dim::load(fp,l);	
	return 0;
}

/*
void main()
{
FILE *file;
cubic l;
	file=fopen("test","w+");
	l.AddKoeff(1);
	l.AddKoeff(2);
	l.AddKoeff(3);
	l.exportPOV(file,2,2);
	fclose(file);
}*/
