#ifndef __CSG__
#define __CSG__

#include "list.h" 
#include "csgobj.h" 
#include "blob.h"  
#include "blobobj.h"  

class csg : public csgobj
{
public:
typedef enum
	{
		UNION,
		MERGE,
		DIFFERENCE,
		INTERSECTION,
		INVERT
	}
	CSG_TYPE;

protected:
	CSG_TYPE	csgtype;
	list<csgobj*>	csglist;

public:
	csg(base *p = NULL,char *n = "Untitled",CSG_TYPE t = UNION);
	~csg();

	CSG_TYPE	getCSGType()
	{
		return csgtype;
	};
	CSG_TYPE	setCSGType(CSG_TYPE t) 
	{ 
		return (csgtype = t); 
	}; 

	virtual void	dumpNames(int,int); 
 
	virtual int	save(FILE*); 
	virtual int	load(FILE*,int); 
 
	virtual int	exportPOV(FILE*,int tab,int tabsize); 

	virtual int	addToParent(base *parent);
	virtual int	removeFromParent(); 
	virtual int	addChild(csgobj *child);
	virtual int	addChild(blob *child); 
	virtual int	addChild(blobobj *child); 
	virtual int	removeChild(csgobj *child); 
	virtual int	removeChild(blob *child); 
	virtual int	removeChild(blobobj *child); 

	virtual void	getChildren(base ***b)
	{
		int	t;
		base	**bt;

		*b = NULL;
		bt = (base**)malloc(sizeof(void*) * (csglist.length() + 1));
		if(!bt) return;

		for(t = 0;t < csglist.length();t++)
			bt[t] = csglist[t];
		bt[t] = NULL;
		*b = bt;
	}

	virtual base	*searchName(char *n);
	virtual int	existsName(char *n);

	virtual int	draw(view *,Matrix44);
};

#endif

