#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "csg.h" 
#include "view.h"

csg::csg(base *p,char *n,CSG_TYPE t) :
	csgobj(p,n)
{
	numtype = NUM_CSG;
	csgtype = t;

	csglist.setErrorValue(NULL);

	if(parent) addToParent(parent);

}

csg::~csg()
{
	csgobj	*c;

	for(c = csglist.getFirst();c != NULL;c = ++csglist)
	{ 
		delete c;
	}
	removeFromParent();
}

void	csg::dumpNames(int tab,int tabsize)
{
	csgobj	*b;

	printTab(stdout,tab);
	printf("csg: %s  ",name);

	switch(getCSGType()) 
	{ 
		case UNION: 
			printf("(union)\n"); 
		break; 
		case MERGE: 
			printf("(merge)\n"); 
		break; 
		case DIFFERENCE: 
			printf("(difference)\n"); 
		break; 
		case INTERSECTION: 
			printf("(intersection)\n"); 
		break; 
		case INVERT:  
			printf("(invert)\n");  
		break;  
	} 
	for(b = csglist.getFirst();b != NULL;b = ++csglist)  
	{  
		b->dumpNames(tab + tabsize,tabsize); 
		csglist.find(b);
	}  
}

int	csg::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	csgobj	*b;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = csg ");

	switch(getCSGType())
	{
		case UNION:
			fprintf(fp,"(union)\n");
		break;
		case MERGE:
			fprintf(fp,"(merge)\n");
		break;
		case DIFFERENCE:
			fprintf(fp,"(difference)\n");
		break;
		case INTERSECTION:
			fprintf(fp,"(intersection)\n");
		break;
		case INVERT: 
			fprintf(fp,"(invert)\n"); 
		break; 
	}

	if(csglist.length() > 1)
	{
		printTab(fp,tab);
		switch(getCSGType())
		{
			case MERGE:
				fprintf(fp,"merge\n");
			break;
			case DIFFERENCE:
				fprintf(fp,"difference\n");
			break;
			case INTERSECTION:
				fprintf(fp,"intersection\n");
			break;
			case INVERT: 
				fprintf(fp,"invert\n"); 
			break; 
			case UNION:
			default:
				fprintf(fp,"union\n");
			break;
		}
	}

	printTab(fp,tab);
	fprintf(fp,"{\n");

	for(b = csglist.getFirst();b != NULL;b = ++csglist)
	{
		b->exportPOV(fp,tab + tabsize,tabsize);
		csglist.find(b);
		if(getCSGType() == INVERT) break;
	}

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	csg::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	csg::removeFromParent()
{
	if(!parent) return -2;
	return parent->removeChild(this);
}

int	csg::addChild(csgobj *child)
{
	if(!child) return -1;
	return csglist += child;
}

int	csg::addChild(blob *child) 
{ 
	if(!child) return -1; 
	return csglist += child; 
} 

int	csg::addChild(blobobj *child) 
{ 
	if(!child) return -1; 
	return csglist += child; 
} 

int	csg::removeChild(csgobj *child) 
{ 
	if(!child) return -1;
	if(csglist.find(child) < 0) return -2;
	return (csglist.deleteCurrent() ? 0 : -3); 
} 

int	csg::removeChild(blob *child) 
{ 
	if(!child) return -1; 
	if(csglist.find(child) < 0) return -2;
	return (csglist.deleteCurrent() ? 0 : -3); 
} 

int	csg::removeChild(blobobj *child) 
{ 
	if(!child) return -1; 
	if(csglist.find(child) < 0) return -2;
	return (csglist.deleteCurrent() ? 0 : -3); 
} 

base	*csg::searchName(char *n)
{
	csgobj	*d;
	char	*c;

	base	*b;

	if(n == NULL) return NULL;

	c = getName();
	if(c != NULL && strcmp(c,n) == 0)
		return this;

	for(d = csglist.getFirst();d != NULL;d = ++csglist)
	{
		if((b = d->searchName(n))) return b;
		csglist.find(d);
	}

	return NULL;
}

int	csg::existsName(char *n) 
{ 
	csgobj	*d; 
	char	*c; 
 
	if(n == NULL) return -1; 
 
	c = getName(); 
	if(c != NULL && strcmp(c,n) == 0) 
		return !0; 
 
	for(d = csglist.getFirst();d != NULL;d = ++csglist) 
	{ 
		if(d->existsName(n)) return !0; 
		csglist.find(d);
	} 
 
	return 0; 
} 
 

int	csg::save(FILE *fp)  
{  
	csgobj	*c;

	setFile(fp);
	writeChunk("CSG ");
	SN(name);
 	fwrite(&csgtype,1,1,fp);

	for(c = csglist.getFirst();c != NULL;c = ++csglist) 
	{ 
		c->save(fp); 
		csglist.find(c);
	} 
 
	writeChunkLen();

	return 0; 
} 

int	csg::load(FILE *fp,int l)
{
	int	pos = ftell(fp);
	base	*b;

	csgtype = UNION;

	fread(&csgtype,1,1,fp);
	while(ftell(fp) < pos + l)
	{
		b = parse(fp);
		if(b)
		{
			b->addToParent(this);
			b->setParent(this);
		}
	}

	return 0;
}

int	csg::draw(view *v,Matrix44 m) 
{ 
	csgobj	*d; 
	int	t;
	Vector3		vec(0,0,0);

	if(v == NULL) return -1; 
 
	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawCross(vec,m);

	for(t = 0;t < csglist.length();t++) 
	{ 
		d = csglist[t];
		d->draw(v,m); 
	} 

 	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0; 
} 
 



