#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cone.h"
#include "num.h"
#include "view.h" 

cone::cone(base *p,char *n,double r) :
	csgobj(p,n)
{
	numtype = NUM_CONE;
	cap_radius=r;

	if(parent) addToParent(parent);
}

cone::~cone()
{
}

int	cone::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	cone::removeFromParent()
{
	if(!parent) return -2;

	return parent->removeChild(this);
}

void	cone::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("cone: %s\n",name);
}

int	cone::exportPOV(FILE *fp,int tab,int tabsize) 
{ 
	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = cone\n");
	printTab(fp,tab);
	fprintf(fp,"cone\n");
	printTab(fp,tab); 
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize); 
	fprintf(fp,"<0,0,0.5>, 0.5, <0,0,-0.5>,%f\n",cap_radius); 

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	cone::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);
	writeChunk("CONE");
	SN(name);

	SD(cap_radius);

	dim::save(fp);

	writeChunkLen();

	return 0;
}

int	cone::load(FILE *fp,int l)
{
	fread(&cap_radius,1,sizeof(double),fp);

	dim::load(fp,l - sizeof(double));

	return 0;
}

int	cone::draw(view *v,Matrix44 m)
{
	Vector3	p,vx,vy,vz;

	//printf("Cone\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(0.5,0,0);
	vy = Vector3(0,0.5,0);
	vz = Vector3(0,0,0.5);

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawCone(p,vx,vy,vz,cap_radius / 2,m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}




