#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "box.h"
#include "num.h"
#include "view.h"



box::box(base *p,char *n) :
	csgobj(p,n)
{
	numtype = NUM_BOX;

	if(parent) 
addToParent(parent);
}

box::~box()
{
	removeFromParent();
}

int	box::addToParent(base *p) 
{ 
	if(!p) return -2; 
 
	parent = p;
	return p->addChild(this); 
} 
 
int	box::removeFromParent() 
{ 
	if(!parent) return -2; 
 
	return parent->removeChild(this); 
} 
 
void	box::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("box: %s\n",name);
}

int	box::exportPOV(FILE *fp,int tab,int tabsize)
{
	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = box\n");
	printTab(fp,tab);
	fprintf(fp,"box\n");

	printTab(fp,tab); 
	fprintf(fp,"{\n");
 	printTab(fp,tab + tabsize);
	fprintf(fp,"<0.5,0.5,0.5>, <-0.5,-0.5,-0.5>\n");

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}


int	box::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);
	writeChunk("BOX ");
	SN(name);
	dim::save(fp);
	writeChunkLen();

	return 0;
}

int	box::load(FILE *fp,int l)
{
	dim::load(fp,l);

	return 0;
}

int	box::draw(view *v,Matrix44 m)
{
	Vector3	p,vx,vy,vz;

	//printf("Box\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(0.5,0,0);
	vy = Vector3(0,0.5,0);
	vz = Vector3(0,0,0.5);

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawBox(p,vx,vy,vz,m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
}


