#include <stdio.h>

#include "blob.h"
#include "view.h"

blob::blob(base *p,char *n,double t) :
	csgobj(p,n)
{
	numtype = NUM_BLOB;
	treshhold = t;

	bloblist.setErrorValue(NULL);

	if(parent) addToParent(parent);
}


blob::~blob()
{
	blobobj	*b;

	while((b = bloblist.getFirst()))
	{
		delete b;
		bloblist.deleteCurrent();
	}
	removeFromParent();
}

int	blob::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	blob::removeFromParent()
{
	if(!parent) return -2;
	return parent->removeChild(this);
}

int	blob::exportPOV(FILE *fp,int tab,int tabsize)
{
	blobobj	*b;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = blob\n");

	printTab(fp,tab);
	fprintf(fp,"blob\n");
	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	fprintf(fp,"treshhold = %f\n",treshhold);

	for(b = bloblist.getFirst();b != NULL;b = ++bloblist)
	{
		b->exportPOV(fp,tab + tabsize,tabsize);
		bloblist.find(b);
	}

	if(texptr) texptr->exportPOV(fp,tab + tabsize,tabsize);
	else texture("white",1,1,1).exportPOV(fp,tab + tabsize,tabsize);

	dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

void	blob::dumpNames(int tab,int tabsize)
{
	int		t;

	printTab(stdout,tab);
	printf("blob: %s\n",name);
	for(t = 0;t < bloblist.length();t++)
		bloblist[t]->dumpNames(tab + tabsize,tabsize);
}

int	blob::addChild(blobobj *b)
{
	if(!b) return -2;

	return bloblist += b;
}

int	blob::removeChild(blobobj *b)
{
	if(!b) return -2;
	if(bloblist.find(b) < 0) return -3;
	return (bloblist.deleteCurrent() ? 0 : -1);
}

int	blob::save(FILE *fp)
{
	blobobj	*b;

	if(!fp) return -1;

	setFile(fp);
	writeChunk("BLOB");
	SN(name);
	SD(treshhold);

	for(b = bloblist.getFirst();b != NULL;b = ++bloblist)
	{
		b->save(fp);
		bloblist.find(b);
	}

	dim::save(fp);

	writeChunkLen();

	return 0;
}

int	blob::load(FILE *fp,int l)
{
	int	pos = ftell(fp);
	base	*b;

	fread(&treshhold,1,sizeof(double),fp);

	while(ftell(fp) < pos + l - (int)sizeof(double) * 12)
	{
		b = parse(fp);
		if(b)
		{
			b->addToParent(this);
			b->setParent(this);
		}
	}

	dim::load(fp,l - (ftell(fp) - pos));

	return 0;
}

base	*blob::searchName(char *n) 
{ 
	blobobj	*d; 
	char	*c; 
 	base	*b;

	if(n == NULL) return NULL; 
 
	c = getName(); 
	if(c != NULL && strcmp(c,n) == 0) 
		return this; 
 
	for(d = bloblist.getFirst();d != NULL;d = ++bloblist) 
	{ 
		if((b = d->searchName(n))) return b; 
		bloblist.find(d);
	} 
 
	return NULL; 
} 
 
int	blob::existsName(char *n) 
{ 
	blobobj	*d; 
	char	*c; 
 
	if(n == NULL) return -1; 
 
	c = getName(); 
	if(c != NULL && strcmp(c,n) == 0) 
		return !0; 
 
	for(d = bloblist.getFirst();d != NULL;d = ++bloblist) 
	{ 
		if(d->existsName(n)) return !0; 
		bloblist.find(d);
	} 
 
	return 0; 
} 

int	blob::draw(view *v,Matrix44 m)
{
	blobobj	*d;
	int	t;
	Vector3	vec(0,0,0);

	if(v == NULL) return -1;

	dimMatrix(m);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawCross(vec,m);

	for(t = 0;t < bloblist.length();t++)
	{
		d = bloblist[t];
		d->draw(v,m); 
	} 

	if(this == v->getSelected()) v->setDrawSelected(0);

	return 0;
} 


