#ifndef base_inc
#define base_inc

#include "num.h"
#include "list.h"

#include "chunk.h"

#include "matmath.h"

class body;
class ref;
class refptr;
class csgobj;
class blobobj;
class sphere; 
class cylinder; 
class nonsolid; 
class world;  

class view;  


class base : public chunk
{
public:
typedef	enum	{
			DRAW_BOUNDINGBOX = 0,
			DRAW_BOUNDINGSPHERE,
			HIDE,
		}
		FLAGS;

protected:
	char		*name;
	int		flags;
	NUM_TYPE	numtype;
	base		*parent;

public:
	base(base *p = NULL,char *n="Untitled");
	virtual ~base();

	virtual base	*searchName(char *n);
	virtual int	existsName(char *n); 
	virtual char	*createName(char *basename);
	virtual char	*getName();
	virtual int	setName(char *n)
	{
		if(name) free(name);
		name = strdup(n);
		return 0;
	}; 
	virtual void	dumpNames(int tabsize = 2);
	virtual void	dumpNames(int,int) = 0;

	int		save3DDS(char*,base*); 
	int		load3DDS(char*,base**); 
	virtual int	save(FILE*) { return -1;}; 
	virtual int	load(FILE*,int); 

	virtual int	exportPOV(FILE*,int tab,int tabsize) = 0;
//	virtual int	exportPOVBody(FILE*,int tab,int tabsize) = 0;

	int		getType() { return numtype; };

	virtual void	getChildren(base ***b) { *b = NULL;};

//	virtual int	paint(view*) = 0;
	virtual int	draw(view*,Matrix44) = 0; 


	virtual int	addToParent(base*) {return -1;};
	virtual int	removeFromParent();

 	virtual int	addChild(base*) {return -1;};
	virtual int	addChild(body*) {return -1;};
	virtual int	addChild(refptr*) {return -1;};
	virtual int	addChild(ref*) {return -1;};
	virtual int	addChild(csgobj*) {return -1;};
	virtual int	addChild(blobobj*) {return -1;};
	virtual int	addChild(nonsolid*) {return -1;}; 

	virtual int	removeChild(base*) {return -1;};
	virtual int	removeChild(body*) {return -1;}; 
	virtual int	removeChild(refptr*) {return -1;}; 
	virtual int	removeChild(ref*) {return -1;}; 
	virtual int	removeChild(csgobj*) {return -1;}; 
	virtual int	removeChild(blobobj*) {return -1;}; 
	virtual int	removeChild(nonsolid*) {return -1;};  

	virtual int	hasChild(base*) {return -1;}; 
	virtual int	hasChild(body*) {return -1;}; 
	virtual int	hasChild(refptr*) {return -1;}; 
	virtual int	hasChild(ref*) {return -1;}; 
	virtual int	hasChild(csgobj*) {return -1;}; 
	virtual int	hasChild(blobobj*) {return -1;}; 
	virtual int	hasChild(nonsolid*) {return -1;};  

	virtual int	moveChild(base*) {return -1;};
	virtual int	moveChild(body*) {return -1;};
	virtual int	moveChild(refptr*) {return -1;};
	virtual int	moveChild(ref*) {return -1;};
	virtual int	moveChild(csgobj*) {return -1;};
	virtual int	moveChild(blobobj*) {return -1;};
	virtual int	moveChild(nonsolid*) {return -1;};


	virtual base	*getParent();
	virtual base	*getRoot();

	base		*parse(FILE *fp);
	void		setParent(base*);

	void		setFlag(FLAGS f,int set = 1)
	{
		if(set)
			flags |= (1 << f);
		else
			flags &= ~(1 << f);
	}

	int		isFlag(FLAGS f)
	{
		return !(!(flags & (1 << f)));
	}

protected:
	void		printTab(FILE *fp,int tab);
};


#endif

