#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "num.h"
#include "base.h"
#include "objects.h"

#include <misc.h>

base::base(base *p,char *n) 
:
	chunk()
{
	parent = NULL;
	numtype = NUM_BASE; 
	flags=0; 
	parent = p;
	name = NULL;
	name = getRoot()->createName(n); 
}

base::~base()
{
	if(parent) parent->removeChild(this);
	//printf("Want to destroy %p\n",this); 
	if(name)
	{
		printf("Destroyed %s %p\n",name,this);
		free(name);
		name = NULL;
	}
}

int	base::removeFromParent()
{
	if(!parent)
	{
		printf("Not connected to parent %s!\n",getName());
		return -1;
	}

	return parent->removeChild(this);
}

base	*base::searchName(char *n)
{
	if(n == NULL) return NULL;

	if(name != NULL && strcmp(name,n) == 0)
		return this;

	return NULL;
}

int	base::existsName(char *n) 
{
	if(n == NULL) return -1;

	if(name != NULL && strcmp(name,n) == 0)
		return !0;

	return 0;
}

char	*base::createName(char *basename)
{
	int		t;
	char		num[10],*cp;

	cp = strdup(basename);

	for(t = 1;existsName(cp);t++)
	{
		sprintf(num,"%i",t);
		cp = (char*)realloc(cp,strlen(basename) + strlen(num) + 1);
		sprintf(cp,"%s%i",basename,t);
	}

	return cp;
}

char	*base::getName()
{
	return name;
}

void	base::dumpNames(int tabsize = 2)
{
	dumpNames(0,tabsize);
}

base	*base::getParent()
{
	return parent;
}

base	*base::getRoot()
{
	base	*b = this;

	while(b != NULL)
	{
		if(b->getParent() == NULL) return b;
		b = b->getParent();
	}

	return NULL;
}

void	base::printTab(FILE *fp,int tab)
{
	int	t;

	for(t = 0;t < tab;t++)
	{
		fprintf(fp," ");
	}
}

base	*base::parse(FILE *fp)
{
	base	*b;
	int	l,pos;
	char	chunk[4];
	char	*n = NULL;

	//printf("start parsing ...\n");

	fread(chunk,1,4,fp);

	fread(&l,1,4,fp);

	pos = ftell(fp);

	b = NULL;

	//printf("test for dim ...\n");

	if(strncmp(chunk,"DIM ",4) != 0 && strncmp(chunk,"NONE",4) != 0)
	{
//		printf("not dim\n");
		n = readName(fp);
	}
	else
	{
		if(strncmp(chunk,"DIM ",4) == 0)
		{
			printf("is dim\n");
			fseek(fp,-8,SEEK_CUR);
			return NULL;
		}
	}

	printf("parse %c%c%c%c named %s of len %i\n",chunk[0],chunk[1],chunk[2],chunk[3],n,l);

	if(strncmp(chunk,"WRLD",4) == 0)
	{
		b = new world(n);
	}
	else if(strncmp(chunk,"BOX ",4) == 0) 
	{ 
		b = new box(NULL,n); 
	} 
	else if(strncmp(chunk,"OBJC",4) == 0)
	{
		b = new obj(NULL,n);
	}
	else if(strncmp(chunk,"REFO",4) == 0)
	{
		b = new ref(NULL,n);
	}
	else if(strncmp(chunk,"REFP",4) == 0)
	{
		b = new refptr(NULL,n);
	}
	else if(strncmp(chunk,"BLOB",4) == 0)
	{
		b = new blob(NULL,n);
	}
	else if(strncmp(chunk,"CSG ",4) == 0)
	{
		b = new csg(NULL,n);
	}
	else if(strncmp(chunk,"SPHR",4) == 0)
	{
		b = new sphere(NULL,n);
	}
	else if(strncmp(chunk,"CYLD",4) == 0)
	{
		b = new cylinder(NULL,n);
	}
	else if(strncmp(chunk,"TRUS",4) == 0)
	{
		b = new torus(NULL,n);
	}
	else if(strncmp(chunk,"CONE",4) == 0)
	{
		b = new cone(NULL,n);
	}
/*	else if(strncmp(chunk,"TEXT",4) == 0)
	{
		b = new text(NULL,n);
	}
	else if(strncmp(chunk,"SCPT",4) == 0)
	{
		b = new script(NULL,n);
	}
	else if(strncmp(chunk,"PLNE",4) == 0)
	{
		b = new plane(NULL,n);
	}
	else if(strncmp(chunk,"HFLD",4) == 0) 
	{ 
		b = new heightfield(NULL,n); 
	} 
*/
/*
	else if(strncmp(chunk,"CUBI",4) == 0) 
	{ 
		b = new cubic(NULL,n); 
	} 
	else if(strncmp(chunk,"DISC",4) == 0) 
	{ 
		b = new disc(NULL,n); 
	} 
	else if(strncmp(chunk,"LATH",4) == 0) 
	{ 
		b = new lathe(NULL,n); 
	} 
	else if(strncmp(chunk,"MESH",4) == 0) 
	{ 
		b = new mesh(NULL,n); 
	} 
	else if(strncmp(chunk,"POL ",4) == 0) 
	{ 
		b = new poly(NULL,n); 
	} 
	else if(strncmp(chunk,"PRIS",4) == 0) 
	{ 
		b = new prism(NULL,n); 
	} 
	else if(strncmp(chunk,"QUAD",4) == 0) 
	{ 
		b = new quadric(NULL,n); 
	} 
	else if(strncmp(chunk,"QART",4) == 0) 
	{ 
		b = new quartic(NULL,n); 
	} 
	else if(strncmp(chunk,"SELL",4) == 0) 
	{ 
		b = new superellipsoid(NULL,n); 
	} 
	else if(strncmp(chunk,"TRIA",4) == 0) 
	{ 
		b = new triangle(NULL,n); 
	} 
*/
	else if(strncmp(chunk,"LPNT",4) == 0) 
	{ 
		b = new lightpoint(NULL,n); 
	} 
/*
	else if(strncmp(chunk,"SPTL",4) == 0) 
	{ 
		b = new spotlight(NULL,n); 
	} 
*/
	// ...
	else fseek(fp,l,SEEK_CUR);

	if(b)
	{
		b->setParent(this);
		if(b->load(fp,l - (ftell(fp) - pos)) != 0)
		{
			delete b;
			fseek(fp,pos + l,SEEK_SET);
			return NULL;
		}
	}

	fseek(fp,pos + l,SEEK_SET);

	return b;
}

int	base::load(FILE *fp,int l)
{
	int	pos = ftell(fp);
	base	*b;

	//printf("load len %i\n",l);
	while(ftell(fp) < pos + l)
	{
		//printf("  go to parse\n");
		b = parse(fp);
		if(b)
		{
			//printf("  go to bind\n");
			b->addToParent(this);
		}
	}

	return 0;
}

int	base::save3DDS(char *fn,base *b)
{
	FILE	*fp;
	int	error;

	if(!fn) return -3;
	if((fp = fopen(fn,"wb")) == NULL) return -4;

	setFile(fp);
	writeChunk("FORM");
	fwrite("3DDS",1,4,fp);

	error = b->save(fp);

	writeChunkLen();

	fclose(fp);

	return error;
}

int	base::load3DDS(char *fn,base **b)
{
	FILE	*fp;
	int	len;
	char	buffer[12];

	*b = NULL;
	if(!fn) return -3;
	if((fp = fopen(fn,"rb")) == NULL) return -4;

	fread(buffer,1,12,fp);

	if(strncmp(buffer,"FORM",4) != 0) return -5;
	len = *(int*)(buffer + 4);
	if(strncmp(buffer + 8,"3DDS",4) != 0) return -6;

	*b = parse(fp);

	fclose(fp);

	return (*b == NULL ? -7:0);
}

void	base::setParent(base *b)
{
	parent = b;
}



