#include "texture.h"

texture::texture(char *n,double rr,double gg,double bb)
{
	name = NULL;
	setName(n);

	r = rr;
	g = gg;
	b = bb;
}

texture::~texture()
{
	if(name) free(name);
}

int	texture::setName(char *n)
{
	if(name) free(name);
	name = strdup(n);
	return 0;
}

char	*texture::getName()
{
	return name;
}

void	texture::setColor(double rr,double gg,double bb)
{
	r = rr;
	g = gg;
	b = bb;
}

int	texture::exportPOV(FILE *fp,int tab,int tabsize)
{
	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = texture\n");
	printTab(fp,tab);
	fprintf(fp,"pigment\n");

	printTab(fp,tab);
	fprintf(fp,"{\n");
 	printTab(fp,tab + tabsize);
	fprintf(fp,"color rgb <%g,%g,%g>\n",r,g,b);

	// dim::exportPOV(fp,tab + tabsize,tabsize);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

void	texture::printTab(FILE *fp,int tab)
{
	int	t;

	for(t = 0;t < tab;t++)
	{
		fprintf(fp," ");
	}
}



