/******************************************************************************
* User_ftl.c - default FatalError function for the user library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, April. 93.					      *
******************************************************************************/

#include <stdio.h>
#include "irit_sm.h"
#include "user_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap User_lib errors right here. Provides a default error handler for the  M
* user library. Gets an error description using UserDescribeError, prints it M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   UserFatalError, error handling                                           M
*****************************************************************************/
void UserFatalError(UserFatalErrorType ErrID)
{
    char
	*ErrorMsg = UserDescribeError(ErrID);

    fprintf(stderr, "USER_LIB: %s\n", ErrorMsg);

    exit(-1);
}
