/******************************************************************************
* User_err.c - handler for all user library fatal errors.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 91.					      *
******************************************************************************/

#include "irit_sm.h"
#include "user_loc.h"

typedef struct UserErrorStruct {
    UserFatalErrorType ErrorNum;
    char *ErrorDesc;
} UserErrorStruct;

static UserErrorStruct ErrMsgs[] =
{
    { USER_ERR_WRONG_SRF,		"Provided surface type is wrong" },
    { USER_ERR_UNDEFINE_ERR,	NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this user library as well as other users. Raised error will  M
* cause an invokation of UserFatalError function which decides how to handle M
* this error. UserFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   UserDescribeError, error handling                                        M
*****************************************************************************/
char *UserDescribeError(UserFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
