/******************************************************************************
* Triv_ftl.c - default FatalError function for the triv library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, April. 93.					      *
******************************************************************************/

#include <stdio.h>
#include "triv_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap Triv_lib errors right here. Provides a default error handler for the  M
* triv library. Gets an error description using TrivDescribeError, prints it M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   TrivFatalError, error handling                                           M
*****************************************************************************/
void TrivFatalError(TrivFatalErrorType ErrID)
{
    char
	*ErrorMsg = TrivDescribeError(ErrID);

    fprintf(stderr, "TRIV_LIB: %s\n", ErrorMsg);

    exit(-1);
}
