/******************************************************************************
* Prsr_loc.h - header file for the data file\s parser library.		      *
* This library is closely related to cagd_lib and should be linked with it.   *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Dec. 94.					      *
******************************************************************************/

#ifndef PRSR_LOC_H
#define PRSR_LOC_H

#ifdef AMIGA
#ifdef DOUBLE
#undef DOUBLE
#define DOUBLE DOUBLE	/* #ifdef DOUBLE will still work, and */
#endif		   /* typedef double DOUBLE in exec/types.h will not fail */
#include <exec/exec.h>
#endif

#include <math.h>
#include <stdio.h>
#include "irit_sm.h"
#include "iritprsr.h"

#ifdef OS2GCC
#define INCL_DOSPROCESS
#include <os2.h>
#endif /* OS2GCC */

#ifdef __WINNT__
#include <winsock.h>
#endif /* __WINNT__ */

#ifdef DOUBLE
#define IP_FLOAT_READ "%lf"
#else
#define IP_FLOAT_READ "%f"
#endif /* DOUBLE */

#define UNGET_STACK_SIZE	5		     /* Internal stack size. */

#define MAX_KNOTS_PER_LINE	5	/* How many knots to print per line. */

typedef enum {			  /* List of all possible tokens enumerated. */
    IP_TOKEN_NONE,

    IP_TOKEN_OPEN_PAREN,
    IP_TOKEN_CLOSE_PAREN,

    IP_TOKEN_E1,
    IP_TOKEN_P1,
    IP_TOKEN_E2,
    IP_TOKEN_P2,
    IP_TOKEN_E3,
    IP_TOKEN_P3,
    IP_TOKEN_E4,
    IP_TOKEN_P4,
    IP_TOKEN_E5,
    IP_TOKEN_P5,

    IP_TOKEN_NUMBER,
    IP_TOKEN_STRING,
    IP_TOKEN_POINT,
    IP_TOKEN_VECTOR,
    IP_TOKEN_MATRIX,
    IP_TOKEN_CTLPT,
    IP_TOKEN_VERTEX,
    IP_TOKEN_POLYGON,
    IP_TOKEN_POLYLINE,
    IP_TOKEN_POINTLIST,
    IP_TOKEN_OBJECT,
    IP_TOKEN_COLOR,
    IP_TOKEN_RGB,
    IP_TOKEN_INTERNAL,
    IP_TOKEN_NORMAL,
    IP_TOKEN_PLANE,
    IP_TOKEN_CURVE,
    IP_TOKEN_SURFACE,

    IP_TOKEN_BEZIER,
    IP_TOKEN_BSPLINE,
    IP_TOKEN_POWER,
    IP_TOKEN_TRIVAR,
    IP_TOKEN_PTYPE,
    IP_TOKEN_NUM_PTS,
    IP_TOKEN_ORDER,
    IP_TOKEN_KV,
    IP_TOKEN_KVP,
    IP_TOKEN_TRIMMDL,
    IP_TOKEN_TRIMSRF,
    IP_TOKEN_TRIMCRV,
    IP_TOKEN_TRIMCRVSEG,

    IP_TOKEN_OTHER	= 100,		/* Probably names & numbers. */
    IP_TOKEN_QUOTED,			/* A quoted string. */

    IP_TOKEN_EOF = -1
} IPTokenType;

#define IP_IS_TOKEN_POINT(Token)  ((Token) >= IP_TOKEN_E1 &&\
				   (Token) <= IP_TOKEN_P5)

#define MAX_NUM_OF_STREAMS	20

#define SOC_TIME_OUT		1000		  /* In 10th of miliseconds. */

typedef struct IPStreamInfoStruct {
    int InUse;
#ifdef OS2GCC
    HPIPE pipIrit;
#endif /* OS2GCC */
#ifdef __WINNT__
    HANDLE pHandle;
#endif /* __WINNT__ */
#if defined(__UNIX__) || defined(__WINNT__)
    int MasterSoc;
#endif /* __UNIX__ || __WINNT__ */
    int IsPipe;
#ifndef AMIGA
    int CommuSoc;
#else
    struct MsgPort *CommuSoc;
    struct MsgPort *ReplySoc;
    int oldpri;
#endif
    int EchoInput;
    FILE *f;
    int IsBinary;
    int SwapEndian;
    int TokenStackPtr;
    char TokenStack[UNGET_STACK_SIZE][LINE_LEN];
    int UnGetChar;
    int LineNum;
    int Read;
    int BufferSize;
    int BufferPtr;
    unsigned char Buffer[LINE_LEN_LONG];
} IPStreamInfoStruct;

extern IPStreamInfoStruct
    _IPStream[MAX_NUM_OF_STREAMS];

extern jmp_buf
    _IritPrsrLongJumpBuffer;
extern int
    _IritPrsrPolyListCirc,
    _IritPrsrReadWriteBinary,
    _IritPrsrGlblParserError,
    _IritPrsrReadOneObject;
extern char
    *_IPGlblFloatFormat;

void _IPUnGetToken(int Handler, char *StringToken);
IPTokenType _IPGetToken(int Handler, char *StringToken);
void _IPGetCloseParenToken(int Handler);
int _IPSkipToCloseParenToken(int Handler);
void _IPParserAbort(IritPrsrErrType ErrNum, char *Msg);

char *_IPReal2Str(RealType R);

char *_IPGetCurveAttributes(int Handler);
char *_IPGetSurfaceAttributes(int Handler);

#ifdef USE_VARARGS
void _IPFprintf(int Handler, int Indent, char *va_alist, ...);
#else
void _IPFprintf(int Handler, int Indent, char *Format, ...);
#endif /* USE_VARARGS */

#ifdef AMIGA
/* These are the names of two environment variables created and destroyed on
   the fly. They're used to make sure that the server and the client know of
   each other's existence. Yes, I know it's a kludge.
*/
#define SERVER_VAR	"IritRunning"
#define CLIENT_VAR	"ClientRunning"

struct IritMessage {
  struct Message msg;
  short		 nbytes;
  unsigned char	 txt[LINE_LEN_LONG];
};
#endif /* AMIGA */

#endif /* PRSR_LOC_H */
